(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     85752,       2320]
NotebookOptionsPosition[     83130,       2242]
NotebookOutlinePosition[     83532,       2259]
CellTagsIndexPosition[     83489,       2256]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"EvaluationNotebook", "[", "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightGray"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.641872453646903*^9, 3.641872474900546*^9}, {
  3.646125712607282*^9, 3.6461257127922926`*^9}}],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.664012055689556*^9, 3.6640120838585978`*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["funkce",
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]], "Subsection",
 CellChangeTimes->{{3.61323945547954*^9, 3.6132394662141542`*^9}, {
  3.6132395729292574`*^9, 3.613239575352396*^9}, {3.6132397890546193`*^9, 
  3.6132397919267836`*^9}, {3.6132444707903996`*^9, 3.613244478053815*^9}, {
  3.6133099855775814`*^9, 3.613309991193903*^9}, {3.613361159142213*^9, 
  3.6133611606554155`*^9}, {3.619347779305542*^9, 3.619347779680564*^9}, {
  3.6642561814186697`*^9, 3.6642561859386764`*^9}},
 Background->RGBColor[
  0.5764705882352941, 0.8588235294117647, 0.611764705882353]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Ymatice", "[", 
    RowBox[{
    "uzel1_", ",", "uzel2_", ",", "Z_", ",", "Y_", ",", "B_", ",", "T_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Ypom", ",", "u1", ",", "u2", ",", "m"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Ypom", "=", 
       FractionBox["1", "Z"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ykm", "=", 
       FractionBox["Ypom", "T"]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Yk0", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["1", "T"]}], ")"}], "*", "Ypom"}], "+", 
        RowBox[{"I", "*", 
         FractionBox["B", "2"]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ym0", "=", 
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "T"}], 
          SuperscriptBox["T", "2"]], "*", "Ypom"}], "+", 
        RowBox[{"I", "*", 
         FractionBox["B", "2"]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "Nejprve", " ", "je", " ", "nutno", " ", "vlo\[ZHacek]it", " ", "na", 
        " ", "diagn\[AAcute]lu", " ", "uzlov\[EAcute]", " ", "admitance"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"m", "=", 
       RowBox[{"DiagonalMatrix", "[", "Y", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "<", 
         RowBox[{
          RowBox[{"Length", "[", "uzel1", "]"}], "+", "1"}]}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"u1", "=", 
          RowBox[{"uzel1", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"u2", "=", 
          RowBox[{"uzel2", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
          "D\[AAcute]le", " ", "pak", " ", "admitance", " ", "v\[SHacek]ech", 
           " ", "okoln\[IAcute]ch", " ", "v\[EHacek]tv\[IAcute]"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"m", "[", 
           RowBox[{"[", 
            RowBox[{"u1", ",", "u1"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"m", "[", 
            RowBox[{"[", 
             RowBox[{"u1", ",", "u1"}], "]"}], "]"}], "+", 
           RowBox[{"Ykm", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "+", 
           RowBox[{"Yk0", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"m", "[", 
           RowBox[{"[", 
            RowBox[{"u2", ",", "u2"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"m", "[", 
            RowBox[{"[", 
             RowBox[{"u2", ",", "u2"}], "]"}], "]"}], "+", 
           RowBox[{"Ykm", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "+", 
           RowBox[{"Ym0", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"nediagonalni", " ", "prvky"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"m", "[", 
           RowBox[{"[", 
            RowBox[{"u1", ",", "u2"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"m", "[", 
            RowBox[{"[", 
             RowBox[{"u1", ",", "u2"}], "]"}], "]"}], "-", 
           RowBox[{"Ykm", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"m", "[", 
           RowBox[{"[", 
            RowBox[{"u2", ",", "u1"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"m", "[", 
            RowBox[{"[", 
             RowBox[{"u2", ",", "u1"}], "]"}], "]"}], "-", 
           RowBox[{"Ykm", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", "m"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dos", "[", 
   RowBox[{"x_", ",", "hod_"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", "ii", "]"}], "]"}], "\[Rule]", 
     RowBox[{"hod", "[", 
      RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", 
      RowBox[{"Length", "@", "x"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.664255385379096*^9, 3.664255438449177*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Vstupn\[IAcute] data optimalizace",
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]], "Subsection",
 CellChangeTimes->{{3.61323945547954*^9, 3.6132394662141542`*^9}, {
  3.6132395729292574`*^9, 3.613239575352396*^9}, {3.6132397890546193`*^9, 
  3.6132397919267836`*^9}, {3.6132444707903996`*^9, 3.613244478053815*^9}, {
  3.6133099855775814`*^9, 3.613309991193903*^9}, {3.613361159142213*^9, 
  3.6133611606554155`*^9}, {3.619347779305542*^9, 3.619347779680564*^9}, {
  3.6642564296866603`*^9, 3.6642564359366693`*^9}},
 Background->RGBColor[
  0.5764705882352941, 0.8588235294117647, 0.611764705882353]],

Cell[BoxData[
 RowBox[{"UZEL", "=", 
  RowBox[{
   RowBox[{"Import", "[", "\"\<uzel.xlsx\>\"", "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6642809819129715`*^9, 3.664281024701419*^9}, {
  3.6642811160446434`*^9, 3.6642811178217454`*^9}}],

Cell[BoxData[
 RowBox[{"UZEL", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.664281040870344*^9, 3.664281089948151*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"vzta\[ZHacek]n\[EAcute]", " ", "nap\[EHacek]t\[IAcute]"}], "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Uvzad", "=", 
    RowBox[{"UZEL", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;", 
        RowBox[{"Length", "@", "UZEL"}]}], ",", "2"}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "ve", " ", "slacku", " ", "a", " ", "PU", " ", "uzlech", " ", "je", " ", 
      "to", " ", "zad\[AAcute]n\[AAcute]", " ", "hodnota"}], ",", " ", 
     RowBox[{"pro", " ", "PQ", " ", "je", " ", "to", " ", "odhad"}]}], "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{"Uzad", "=", 
    RowBox[{"UZEL", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;", 
        RowBox[{"Length", "@", "UZEL"}]}], ",", "3"}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"hodnoty", " ", "\[UAcute]hl\[URing]"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"\[Delta]zad", "=", 
    RowBox[{"UZEL", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;", 
        RowBox[{"Length", "@", "UZEL"}]}], ",", "4"}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"PQ", "-", "1"}], ",", 
     RowBox[{"PU", "-", "2"}], ",", 
     RowBox[{"Slack", "-", "3"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"typyUzlu", "=", 
    RowBox[{
     RowBox[{"UZEL", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", 
         RowBox[{"Length", "@", "UZEL"}]}], ",", "5"}], "]"}], "]"}], "//", 
     "Round"}]}]}]}]], "Input",
 CellChangeTimes->{{3.664014799882289*^9, 3.6640148263098006`*^9}, {
   3.6640158447643423`*^9, 3.6640158701293793`*^9}, {3.6641886862885184`*^9, 
   3.664188686678519*^9}, 3.664190220703661*^9, {3.664289445163375*^9, 
   3.66428954053983*^9}, {3.6642898267583137`*^9, 3.664289854229962*^9}, {
   3.6642902849716916`*^9, 3.6642902866720943`*^9}, 3.664290353112831*^9, {
   3.6642909292686434`*^9, 3.664290941842265*^9}, {3.6642910163287783`*^9, 
   3.664291032232688*^9}, {3.6642940949791784`*^9, 3.6642941008905168`*^9}, {
   3.6642976096422057`*^9, 3.664297615745555*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"vzta\[ZHacek]n\[EAcute]", " ", "hodnoty"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Sv", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Zv", "=", 
    FractionBox[
     SuperscriptBox["Uvzad", "2"], "Sv"]}], "\[IndentingNewLine]", 
   RowBox[{"Iv", "=", 
    FractionBox["Sv", 
     RowBox[{
      SqrtBox["3"], "*", "Uvzad"}]]}]}]}]], "Input",
 CellChangeTimes->{{3.6642976227979584`*^9, 3.664297630097376*^9}, {
  3.6642979178708353`*^9, 3.6642979524158115`*^9}, {3.6666907594049892`*^9, 
  3.666690808262062*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"pozice", " ", "jednotliv\[YAcute]ch", " ", "typ\[URing]"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"PQPoz", "=", 
    RowBox[{
     RowBox[{"Position", "[", 
      RowBox[{"typyUzlu", ",", "1"}], "]"}], "/.", 
     RowBox[{
      RowBox[{"{", "x_", "}"}], "\[Rule]", "x"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"PUPoz", "=", 
    RowBox[{
     RowBox[{"Position", "[", 
      RowBox[{"typyUzlu", ",", "2"}], "]"}], "/.", 
     RowBox[{
      RowBox[{"{", "x_", "}"}], "\[Rule]", "x"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"SlackPoz", "=", 
    RowBox[{
     RowBox[{"Position", "[", 
      RowBox[{"typyUzlu", ",", "3"}], "]"}], "/.", 
     RowBox[{
      RowBox[{"{", "x_", "}"}], "\[Rule]", "x"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.6641860484354105`*^9, 3.6641860570754285`*^9}, {
  3.6641866163035455`*^9, 3.664186757304823*^9}, {3.664256455809699*^9, 
  3.664256471239721*^9}, {3.6642572807328696`*^9, 3.664257302912902*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Sv", "=", "1"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Pdod", "-", "Podb"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PWzad", "=", 
    FractionBox[
     RowBox[{
      RowBox[{"UZEL", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;", 
          RowBox[{"Length", "@", "UZEL"}]}], ",", "6"}], "]"}], "]"}], "-", 
      RowBox[{"UZEL", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;", 
          RowBox[{"Length", "@", "UZEL"}]}], ",", "8"}], "]"}], "]"}]}], 
     "Sv"]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Qdod", "-", "Qodb"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QWzad", "=", 
    FractionBox[
     RowBox[{
      RowBox[{"UZEL", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;", 
          RowBox[{"Length", "@", "UZEL"}]}], ",", "7"}], "]"}], "]"}], "-", 
      RowBox[{"UZEL", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;", 
          RowBox[{"Length", "@", "UZEL"}]}], ",", "9"}], "]"}], "]"}]}], 
     "Sv"]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "dosazovac\[IAcute]", " ", "vektor", " ", 
    "\[ZHacek]\[AAcute]dan\[YAcute]ch", " ", "hodnot", " ", 
    "v\[YAcute]kon\[URing]", " ", "v", " ", "uzlech", " ", "PQ", " ", "a", 
    " ", "PU"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["P", "ii"], "\[Rule]", 
     RowBox[{"%%", "[", 
      RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", 
      RowBox[{"Join", "[", 
       RowBox[{"PQPoz", ",", "PUPoz"}], "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"PQWDos", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"%", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["Q", "ii"], "\[Rule]", 
       RowBox[{"%%", "[", 
        RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "PQPoz"}], "}"}]}], "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6640134196975746`*^9, 3.66401342433384*^9}, {
   3.664013457711749*^9, 3.664013491341673*^9}, {3.6640135300848885`*^9, 
   3.6640135341611214`*^9}, 3.6640136464005413`*^9, {3.664185028929927*^9, 
   3.6641850568589673`*^9}, {3.6641891692205076`*^9, 
   3.6641891704205093`*^9}, {3.6641902564327126`*^9, 3.664190257152714*^9}, {
   3.6642117459352655`*^9, 3.6642117644216986`*^9}, {3.6642118073789754`*^9, 
   3.6642118332372217`*^9}, {3.664211898227138*^9, 3.6642119423798194`*^9}, {
   3.6642119834560924`*^9, 3.6642120394045925`*^9}, {3.6642144078032637`*^9, 
   3.6642144227902875`*^9}, {3.6642146707884474`*^9, 3.664214678563464*^9}, {
   3.6642570635485463`*^9, 3.6642571005946026`*^9}, {3.6642573453269644`*^9, 
   3.6642573475749683`*^9}, {3.664257755085163*^9, 3.66425776607718*^9}, 
   3.6642676273053265`*^9, {3.664293476704815*^9, 3.6642935334380603`*^9}, {
   3.664293599974866*^9, 3.6642936104244633`*^9}, {3.664294081982435*^9, 
   3.664294086915717*^9}, {3.664294491944884*^9, 3.6642945452249312`*^9}, {
   3.6642945790798674`*^9, 3.664294612831798*^9}, 3.6642949662140102`*^9, 
   3.664297531002708*^9, 3.6642975693389006`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Pevn\[EAcute]", " ", "hodnoty", " ", "nap\[EHacek]t\[IAcute]", " ", "U", 
     " ", "a", " ", "\[UAcute]hly", " ", "\[Delta]"}], ",", " ", 
    RowBox[{"kter\[EAcute]", " ", "nechceme", " ", 
     RowBox[{"zji\[SHacek]\[THacek]ovat", "."}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "pro", " ", "slack", " ", "je", " ", "to", " ", "\[UAcute]hel", " ", 
    "\[Delta]", " ", "a", " ", "jeho", " ", "velikost", " ", "U"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "pro", " ", "PU", " ", "uzly", " ", "je", " ", "to", " ", "pouze", " ", 
    "velikost", " ", "U"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"\[Delta]UPevnaDos", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox["U", "uzel"], "\[Rule]", 
           RowBox[{"Uzad", "[", 
            RowBox[{"[", "uzel", "]"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[Delta]", "uzel"], "\[Rule]", 
           RowBox[{"\[Delta]zad", "[", 
            RowBox[{"[", "uzel", "]"}], "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"uzel", ",", "SlackPoz"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["U", "uzel"], "\[Rule]", 
          RowBox[{"Uzad", "[", 
           RowBox[{"[", "uzel", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"uzel", ",", "PUPoz"}], "}"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], "//", "Flatten"}]}]}]], "Input",
 CellChangeTimes->{{3.664188705915547*^9, 3.6641887916156836`*^9}, {
   3.6641888296047378`*^9, 3.6641889810319715`*^9}, {3.664189033230051*^9, 
   3.664189073745109*^9}, 3.6641894004008446`*^9, {3.664190078698454*^9, 
   3.664190081358457*^9}, {3.664257129102645*^9, 3.6642571769167147`*^9}, {
   3.664257372026005*^9, 3.664257375126009*^9}, {3.6642577794402*^9, 
   3.6642577869502106`*^9}, {3.6642587683237495`*^9, 3.66425876872375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "promenne", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Join", "[", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
      "pro", " ", "v\[SHacek]echny", " ", "uzly", " ", "typu", " ", "PQ", " ",
        "a", " ", "PU", " ", "hled\[AAcute]me", " ", "\[UAcute]hel"}], "*)"}],
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        SubscriptBox["\[Delta]", "uzel"], ",", 
        RowBox[{"{", 
         RowBox[{"uzel", ",", 
          RowBox[{"Join", "[", 
           RowBox[{"PQPoz", ",", "PUPoz"}], "]"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "velikosti", " ", "nap\[EHacek]t\[IAcute]", " ", "hled\[AAcute]me", 
        " ", "pouze", " ", "pro", " ", "PQ", " ", "uzly"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{
        SubscriptBox["U", "uzel"], ",", 
        RowBox[{"{", 
         RowBox[{"uzel", ",", "PQPoz"}], "}"}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"\[Delta]U", "=", "%"}], "\[IndentingNewLine]", 
   RowBox[{"PQ", "=", 
    RowBox[{"%", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Delta]", "\[Rule]", "P"}], ",", 
       RowBox[{"U", "\[Rule]", "Q"}]}], "}"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.6044686915196915`*^9, 3.6044687022369103`*^9}, {
   3.6044694957468987`*^9, 3.6044695633886175`*^9}, {3.60447066409804*^9, 
   3.604470684098068*^9}, {3.60447177329836*^9, 3.6044717790083675`*^9}, {
   3.6044783808905334`*^9, 3.604478455980657*^9}, 3.6044784928655205`*^9, {
   3.6044786626357584`*^9, 3.604478711715827*^9}, {3.604478748005878*^9, 
   3.6044789303261333`*^9}, 3.6044789976762276`*^9, {3.6044793473897552`*^9, 
   3.6044794133298473`*^9}, 3.604479584600087*^9, {3.604485014164492*^9, 
   3.6044850895588045`*^9}, {3.6044857427061625`*^9, 3.604485761353229*^9}, {
   3.6073641537624006`*^9, 3.607364161241828*^9}, {3.6073642063374076`*^9, 
   3.6073642124007545`*^9}, {3.664013777619528*^9, 3.6640137817395334`*^9}, {
   3.6640144075988517`*^9, 3.6640144278040075`*^9}, {3.664014482164117*^9, 
   3.664014558397477*^9}, {3.664014630726614*^9, 3.6640146440953784`*^9}, {
   3.6640146895059757`*^9, 3.664014770804626*^9}, {3.66401483801147*^9, 
   3.6640149820547085`*^9}, {3.6640153480057445`*^9, 3.664015361156767*^9}, {
   3.66401543873203*^9, 3.6640154623790765`*^9}, {3.6641896788914967`*^9, 
   3.6641896859115067`*^9}, {3.6642117773093214`*^9, 3.664211779620126*^9}, {
   3.6642572604868393`*^9, 3.664257273426858*^9}, {3.6642573823030195`*^9, 
   3.664257487585174*^9}}],

Cell[BoxData[
 RowBox[{"UU", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["U", "i"], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", "*", 
       SubscriptBox["\[Delta]", "i"]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "@", "Uzad"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6640122039295006`*^9, 3.664012212769513*^9}, {
   3.6640125966770525`*^9, 3.664012612714076*^9}, {3.6641899909513254`*^9, 
   3.6641900110513554`*^9}, {3.664190092073473*^9, 3.6641900929634743`*^9}, 
   3.6642086794756393`*^9, {3.6642091951874247`*^9, 3.6642091982138295`*^9}, {
   3.664257700879083*^9, 3.664257723841117*^9}, 3.664257816656255*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"po\[CHacek]\[AAcute]te\[CHacek]n\[IAcute]", " ", "odhady"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"\[Delta]U0Dos", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox["U", "uzel"], "\[Rule]", 
           RowBox[{"Uzad", "[", 
            RowBox[{"[", "uzel", "]"}], "]"}]}], ",", 
          RowBox[{
           SubscriptBox["\[Delta]", "uzel"], "\[Rule]", 
           RowBox[{"\[Delta]zad", "[", 
            RowBox[{"[", "uzel", "]"}], "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"uzel", ",", "PQPoz"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Delta]", "uzel"], "\[Rule]", 
          RowBox[{"\[Delta]zad", "[", 
           RowBox[{"[", "uzel", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"uzel", ",", "PUPoz"}], "}"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], "//", "Flatten"}]}]}]], "Input",
 CellChangeTimes->{{3.664188655709446*^9, 3.6641886653694887`*^9}, 
   3.664188695519532*^9, {3.664189286853679*^9, 3.6641893938008356`*^9}, 
   3.6641897504886003`*^9, 3.6642127283855553`*^9, {3.6642576279229736`*^9, 
   3.664257645565998*^9}, 3.664258016986313*^9, {3.6642587858687763`*^9, 
   3.664258786208777*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Popis s\[IAcute]t\[EHacek] - admitan\[CHacek]n\
\[IAcute] matice",
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]], "Subsection",
 CellChangeTimes->{{3.61323945547954*^9, 3.6132394662141542`*^9}, {
  3.6132395729292574`*^9, 3.613239575352396*^9}, {3.6132397890546193`*^9, 
  3.6132397919267836`*^9}, {3.6132444707903996`*^9, 3.613244478053815*^9}, {
  3.6133099855775814`*^9, 3.613309991193903*^9}, {3.613361159142213*^9, 
  3.6133611606554155`*^9}, {3.619347779305542*^9, 3.619347779680564*^9}, {
  3.6642562023677015`*^9, 3.6642562108577147`*^9}},
 Background->RGBColor[
  0.5764705882352941, 0.8588235294117647, 0.611764705882353]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"VETEV", "=", 
   RowBox[{
    RowBox[{"Import", "[", "\"\<vetev.xlsx\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.6642966859653745`*^9, 3.664296727985778*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"propoje", " ", "mezi", " ", "uzly"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"uzel1", "=", 
    RowBox[{
     RowBox[{"VETEV", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", 
         RowBox[{"Length", "@", "VETEV"}]}], ",", "1"}], "]"}], "]"}], "//", 
     "Round"}]}], "\[IndentingNewLine]", 
   RowBox[{"uzel2", "=", 
    RowBox[{
     RowBox[{"VETEV", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", 
         RowBox[{"Length", "@", "VETEV"}]}], ",", "2"}], "]"}], "]"}], "//", 
     "Round"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6336676242218046`*^9, 3.6336676692243786`*^9}, {
  3.6640084076287107`*^9, 3.6640084164587226`*^9}, {3.664008529982894*^9, 
  3.664008533042898*^9}, {3.664297160612523*^9, 3.6642972576680737`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "vektor", " ", "uzlov\[YAcute]ch", " ", "admitanc\[IAcute]", " ", 
    "sousledn\[EAcute]", " ", "slo\[ZHacek]ky"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Y1", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"Max", "[", 
      RowBox[{"Join", "[", 
       RowBox[{"uzel1", ",", "uzel2"}], "]"}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6330753522238503`*^9, 3.633075385646762*^9}, {
   3.63307599562825*^9, 3.633076016500444*^9}, {3.6330761777126646`*^9, 
   3.633076243281415*^9}, {3.633076299126609*^9, 3.633076349678501*^9}, {
   3.633078446321211*^9, 3.6330784507804656`*^9}, 3.6330787610702133`*^9, {
   3.63307880822091*^9, 3.6330788090999603`*^9}, {3.6336673965657835`*^9, 
   3.6336674437264805`*^9}, {3.6336685600873327`*^9, 
   3.6336685603713493`*^9}, {3.6336773893923407`*^9, 
   3.6336773898293653`*^9}, {3.6336809734073343`*^9, 
   3.6336809748444166`*^9}, {3.6640084306407423`*^9, 
   3.6640084313007436`*^9}, {3.6642970919965982`*^9, 
   3.6642971499889154`*^9}, {3.664297267123615*^9, 3.664297273579984*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "vektor", " ", "meziuzlov\[YAcute]ch", " ", "impedanc\[IAcute]", " ", "a", 
    " ", "susceptanc\[IAcute]", " ", "sousledn\[EAcute]", " ", 
    "slo\[ZHacek]ky"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"R1", "=", 
     RowBox[{"VETEV", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", 
         RowBox[{"Length", "@", "VETEV"}]}], ",", "3"}], "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"X1", "=", 
     RowBox[{"VETEV", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", 
         RowBox[{"Length", "@", "VETEV"}]}], ",", "4"}], "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Zkm1", "=", 
    FractionBox[
     RowBox[{"R1", "+", 
      RowBox[{"I", "*", "X1"}]}], 
     RowBox[{"Zv", "[", 
      RowBox[{"[", "uzel1", "]"}], "]"}]]}], "\[IndentingNewLine]", 
   RowBox[{"B1", "=", 
    RowBox[{
     RowBox[{"VETEV", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", 
         RowBox[{"Length", "@", "VETEV"}]}], ",", "5"}], "]"}], "]"}], "*", 
     RowBox[{"Zv", "[", 
      RowBox[{"[", "uzel1", "]"}], "]"}], "*", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}]}], "\[IndentingNewLine]", 
   RowBox[{"T", "=", 
    RowBox[{"VETEV", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;", 
        RowBox[{"Length", "@", "VETEV"}]}], ",", "6"}], "]"}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6330763944300604`*^9, 3.633076558310434*^9}, {
   3.633076724265926*^9, 3.633076755217696*^9}, {3.633076821408482*^9, 
   3.6330768356802983`*^9}, {3.6330769028551407`*^9, 3.633076927160531*^9}, {
   3.633076993564329*^9, 3.6330770035078974`*^9}, {3.6330770796202507`*^9, 
   3.6330770927210007`*^9}, {3.6330771593358107`*^9, 3.6330771866713743`*^9}, 
   3.6330772274007034`*^9, {3.633667464285657*^9, 3.6336674810676165`*^9}, {
   3.633667540309005*^9, 3.633667574686971*^9}, {3.633667681524082*^9, 
   3.6336677794016805`*^9}, {3.664008496627842*^9, 3.664008541802911*^9}, {
   3.6640086033987074`*^9, 3.664008604548709*^9}, {3.6640086382607565`*^9, 
   3.6640086569627886`*^9}, {3.664008850835146*^9, 3.6640089019182243`*^9}, {
   3.6642972958282566`*^9, 3.6642973666053047`*^9}, {3.6642974616107388`*^9, 
   3.6642974986668587`*^9}, {3.6642981749675407`*^9, 
   3.6642982068713655`*^9}, {3.664298258861339*^9, 3.664298278397456*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ymat", "=", 
   RowBox[{"Ymatice", "[", 
    RowBox[{
    "uzel1", ",", "\[IndentingNewLine]", "uzel2", ",", "\[IndentingNewLine]", 
     "Zkm1", ",", "\[IndentingNewLine]", "Y1", ",", "\[IndentingNewLine]", 
     "B1", ",", "\[IndentingNewLine]", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.664010033232936*^9, 3.6640100437679515`*^9}, {
  3.6640121142576413`*^9, 3.6640121161676435`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["J",
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]], "Subsection",
 CellChangeTimes->{{3.61323945547954*^9, 3.6132394662141542`*^9}, {
  3.6132395729292574`*^9, 3.613239575352396*^9}, {3.6132397890546193`*^9, 
  3.6132397919267836`*^9}, {3.6132444707903996`*^9, 3.613244478053815*^9}, {
  3.6133099855775814`*^9, 3.613309991193903*^9}, {3.613361159142213*^9, 
  3.6133611606554155`*^9}, {3.619347779305542*^9, 3.619347779680564*^9}, {
  3.6642564296866603`*^9, 3.6642564359366693`*^9}, {3.664260458526645*^9, 
  3.664260459536647*^9}},
 Background->RGBColor[
  0.5764705882352941, 0.8588235294117647, 0.611764705882353]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     OverscriptBox[
      RowBox[{"\[Delta]", "U"}], 
      StyleBox["\.af",
       SpanMinSize->0.,
       SpanMaxSize->DirectedInfinity[1]],
      DiacriticalPositioning->True], "k"], "=", 
    RowBox[{"[", GridBox[{
       {
        SuperscriptBox[
         OverscriptBox["\[Delta]", "\.af",
          DiacriticalPositioning->True], "k"]},
       {
        SuperscriptBox[
         OverscriptBox["U", "\.af",
          DiacriticalPositioning->True], "k"]}
      }], "]"}]}], TraditionalForm]],
  FontFamily->"Times New Roman"],
 "\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["S", "^",
      DiacriticalPositioning->True], "(", 
     SuperscriptBox[
      OverscriptBox[
       RowBox[{"\[Delta]", "U"}], 
       StyleBox["\.af",
        SpanMinSize->0.,
        SpanMaxSize->DirectedInfinity[1]],
       DiacriticalPositioning->True], "k"], ")"}], "=", 
    RowBox[{
     RowBox[{"(", GridBox[{
        {
         RowBox[{
          SubscriptBox["U", "1"], 
          SuperscriptBox["e", 
           RowBox[{
            RowBox[{"\[Minus]", "i"}], 
            SubscriptBox["\[Delta]", "1"]}]]}], "0", "0", "0"},
        {"0", 
         RowBox[{
          SubscriptBox["U", "2"], 
          SuperscriptBox["e", 
           RowBox[{
            RowBox[{"\[Minus]", "i"}], 
            SubscriptBox["\[Delta]", "2"]}]]}], "0", "0"},
        {"0", "0", "\[DescendingEllipsis]", "0"},
        {"0", "0", "0", 
         RowBox[{
          SubscriptBox["U", "n"], 
          SuperscriptBox["e", 
           RowBox[{
            RowBox[{"\[Minus]", "i"}], 
            SubscriptBox["\[Delta]", "n"]}]]}]}
       }], ")"}], ".", 
     RowBox[{"(", GridBox[{
        {
         SubscriptBox[
          OverscriptBox["Y", "^",
           DiacriticalPositioning->True], 
          RowBox[{"1", ",", "1"}]], 
         SubscriptBox[
          OverscriptBox["Y", "^",
           DiacriticalPositioning->True], 
          RowBox[{"1", ",", "2"}]], "\[CenterEllipsis]", 
         SubscriptBox[
          OverscriptBox["Y", "^",
           DiacriticalPositioning->True], 
          RowBox[{"1", ",", "3"}]]},
        {
         SubscriptBox[
          OverscriptBox["Y", "^",
           DiacriticalPositioning->True], 
          RowBox[{"2", ",", "1"}]], 
         SubscriptBox[
          OverscriptBox["Y", "^",
           DiacriticalPositioning->True], 
          RowBox[{"2", ",", "2"}]], "\[CenterEllipsis]", 
         SubscriptBox[
          OverscriptBox["Y", "^",
           DiacriticalPositioning->True], 
          RowBox[{"2", ",", "3"}]]},
        {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
         "\[DescendingEllipsis]", "\[VerticalEllipsis]"},
        {
         SubscriptBox[
          OverscriptBox["Y", "^",
           DiacriticalPositioning->True], 
          RowBox[{"n", ",", "1"}]], 
         SubscriptBox[
          OverscriptBox["Y", "^",
           DiacriticalPositioning->True], 
          RowBox[{"n", ",", "2"}]], "\[CenterEllipsis]", 
         SubscriptBox[
          OverscriptBox["Y", "^",
           DiacriticalPositioning->True], 
          RowBox[{"n", ",", "n"}]]}
       }], ")"}], ".", 
     RowBox[{"(", GridBox[{
        {
         RowBox[{
          SubscriptBox["U", "1"], 
          SuperscriptBox["e", 
           RowBox[{
            RowBox[{"\[Minus]", "i"}], 
            SubscriptBox["\[Delta]", "1"]}]]}]},
        {
         RowBox[{
          SubscriptBox["U", "2"], 
          SuperscriptBox["e", 
           RowBox[{
            RowBox[{"\[Minus]", "i"}], 
            SubscriptBox["\[Delta]", "2"]}]]}]},
        {"\[VerticalEllipsis]"},
        {
         RowBox[{
          SubscriptBox["U", "n"], 
          SuperscriptBox["e", 
           RowBox[{
            RowBox[{"\[Minus]", "i"}], 
            SubscriptBox["\[Delta]", "n"]}]]}]}
       }], ")"}]}]}], TraditionalForm]],
  FontFamily->"Times New Roman"]
}], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.6642678139486017`*^9, 3.664267833740631*^9}, {
   3.664267912815747*^9, 3.6642679334477777`*^9}, {3.6642690092936063`*^9, 
   3.664269010173608*^9}, {3.664269046512661*^9, 3.6642690471126623`*^9}, {
   3.6642701088136835`*^9, 3.6642701648767653`*^9}, {3.6642702081878276`*^9, 
   3.6642702081878276`*^9}, {3.664270296808959*^9, 3.6642702975889597`*^9}, {
   3.664271821516523*^9, 3.664271837841547*^9}},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SS", "=", 
   RowBox[{
    RowBox[{"DiagonalMatrix", "[", "UU", "]"}], ".", 
    RowBox[{"Conjugate", "[", "ymat", "]"}], ".", 
    RowBox[{"Conjugate", "[", "UU", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.6640161988118534`*^9, 3.6640161998318553`*^9}, {
   3.6640162550829353`*^9, 3.6640162600229425`*^9}, {3.6640163429890623`*^9, 
   3.6640163590860863`*^9}, {3.664016474083253*^9, 3.664016496365286*^9}, 
   3.664016529563334*^9, {3.6640168331690283`*^9, 3.66401683446903*^9}, {
   3.664016875980089*^9, 3.664016882660099*^9}, {3.664258034098338*^9, 
   3.664258056929372*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       OverscriptBox["P", "\.af",
        DiacriticalPositioning->True], "(", 
       SuperscriptBox[
        OverscriptBox[
         RowBox[{"\[Delta]", "U"}], 
         StyleBox["\.af",
          SpanMinSize->0.,
          SpanMaxSize->DirectedInfinity[1]],
         DiacriticalPositioning->True], "k"], ")"}], "=", 
      RowBox[{"Re", 
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["S", "^",
          DiacriticalPositioning->True], "(", 
         SuperscriptBox[
          OverscriptBox[
           RowBox[{"\[Delta]", "U"}], 
           StyleBox["\.af",
            SpanMinSize->0.,
            SpanMaxSize->DirectedInfinity[1]],
           DiacriticalPositioning->True], "k"], ")"}], "}"}]}]}]},
    {
     RowBox[{
      RowBox[{
       OverscriptBox["Q", "\.af",
        DiacriticalPositioning->True], "(", 
       SuperscriptBox[
        OverscriptBox[
         RowBox[{"\[Delta]", "U"}], 
         StyleBox["\.af",
          SpanMinSize->0.,
          SpanMaxSize->DirectedInfinity[1]],
         DiacriticalPositioning->True], "k"], ")"}], "=", 
      RowBox[{"Im", 
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["S", "^",
          DiacriticalPositioning->True], "(", 
         SuperscriptBox[
          OverscriptBox[
           RowBox[{"\[Delta]", "U"}], 
           StyleBox["\.af",
            SpanMinSize->0.,
            SpanMaxSize->DirectedInfinity[1]],
           DiacriticalPositioning->True], "k"], ")"}], "}"}]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}], TraditionalForm]],
 FontFamily->"Times New Roman"]], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.6642678139486017`*^9, 3.664267833740631*^9}, {
   3.664267912815747*^9, 3.6642679334477777`*^9}, {3.6642690092936063`*^9, 
   3.664269010173608*^9}, {3.664269046512661*^9, 3.6642690471126623`*^9}, {
   3.6642701088136835`*^9, 3.6642701648767653`*^9}, {3.6642702081878276`*^9, 
   3.6642702081878276`*^9}, {3.6642702690229177`*^9, 3.66427031042498*^9}},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[BoxData[
 RowBox[{"SSDos", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["P", "uzel"], "\[Rule]", 
        RowBox[{"ComplexExpand", "[", 
         RowBox[{"Re", "[", 
          RowBox[{"SS", "[", 
           RowBox[{"[", "uzel", "]"}], "]"}], "]"}], "]"}]}], ",", 
       RowBox[{
        SubscriptBox["Q", "uzel"], "\[Rule]", 
        RowBox[{"ComplexExpand", "[", 
         RowBox[{"Im", "[", 
          RowBox[{"SS", "[", 
           RowBox[{"[", "uzel", "]"}], "]"}], "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"uzel", ",", "1", ",", 
       RowBox[{"Length", "@", "UU"}]}], "}"}]}], "]"}], "//", 
   "Flatten"}]}]], "Input",
 CellChangeTimes->{{3.6640168548710585`*^9, 3.664016863831072*^9}, {
  3.6640171202836647`*^9, 3.6640171445336986`*^9}, {3.6641905515121408`*^9, 
  3.664190596533206*^9}, {3.664190646419278*^9, 3.664190713187375*^9}, {
  3.664209259225537*^9, 3.664209282407178*^9}, {3.6642133691861696`*^9, 
  3.66421336940457*^9}, {3.664258086633416*^9, 3.6642581254974737`*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[GridBox[{
     {
      RowBox[{
       RowBox[{
        OverscriptBox["P", "\.af",
         DiacriticalPositioning->True], "(", 
        SuperscriptBox[
         OverscriptBox[
          RowBox[{"\[Delta]", "U"}], 
          StyleBox["\.af",
           SpanMinSize->0.,
           SpanMaxSize->DirectedInfinity[1]],
          DiacriticalPositioning->True], "k"], ")"}], "=", 
       RowBox[{"Re", 
        RowBox[{"{", 
         RowBox[{
          OverscriptBox["S", "^",
           DiacriticalPositioning->True], "(", 
          SuperscriptBox[
           OverscriptBox[
            RowBox[{"\[Delta]", "U"}], 
            StyleBox["\.af",
             SpanMinSize->0.,
             SpanMaxSize->DirectedInfinity[1]],
            DiacriticalPositioning->True], "k"], ")"}], "}"}]}]}]},
     {
      RowBox[{
       RowBox[{
        OverscriptBox["Q", "\.af",
         DiacriticalPositioning->True], "(", 
        SuperscriptBox[
         OverscriptBox[
          RowBox[{"\[Delta]", "U"}], 
          StyleBox["\.af",
           SpanMinSize->0.,
           SpanMaxSize->DirectedInfinity[1]],
          DiacriticalPositioning->True], "k"], ")"}], "=", 
       RowBox[{"Im", 
        RowBox[{"{", 
         RowBox[{
          OverscriptBox["S", "^",
           DiacriticalPositioning->True], "(", 
          SuperscriptBox[
           OverscriptBox[
            RowBox[{"\[Delta]", "U"}], 
            StyleBox["\.af",
             SpanMinSize->0.,
             SpanMaxSize->DirectedInfinity[1]],
            DiacriticalPositioning->True], "k"], ")"}], "}"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}], TraditionalForm]],
  FontFamily->"Times New Roman"],
 "\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"J", "(", 
     SuperscriptBox[
      OverscriptBox[
       RowBox[{"\[Delta]", "U"}], 
       StyleBox["\.af",
        SpanMinSize->0.,
        SpanMaxSize->DirectedInfinity[1]],
       DiacriticalPositioning->True], "k"], ")"}], "=", 
    RowBox[{"(", GridBox[{
       {
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["P", "1"]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["\[Delta]", "1"]}]], "\[CenterEllipsis]", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["P", "1"]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["\[Delta]", 
           SubscriptBox["n", 
            RowBox[{"P", "Q", "P", "U"}]]]}]], 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["P", "1"]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["U", "1"]}]], "\[CenterEllipsis]", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["P", "1"]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["U", 
           SubscriptBox["n", 
            RowBox[{"P", "Q"}]]]}]]},
       {"\[VerticalEllipsis]", "\[DescendingEllipsis]", "\[VerticalEllipsis]",
         "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
        "\[VerticalEllipsis]"},
       {
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["P", 
           SubscriptBox["n", 
            RowBox[{"P", "Q", "P", "U"}]]]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["\[Delta]", "1"]}]], "\[CenterEllipsis]", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["P", 
           SubscriptBox["n", 
            RowBox[{"P", "Q", "P", "U"}]]]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["\[Delta]", 
           SubscriptBox["n", 
            RowBox[{"P", "Q", "P", "U"}]]]}]], 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["P", 
           SubscriptBox["n", 
            RowBox[{"P", "Q", "P", "U"}]]]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["U", "1"]}]], "\[CenterEllipsis]", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["P", 
           SubscriptBox["n", 
            RowBox[{"P", "Q", "P", "U"}]]]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["U", 
           SubscriptBox["n", 
            RowBox[{"P", "Q"}]]]}]]},
       {
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["Q", "1"]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["\[Delta]", "1"]}]], "\[CenterEllipsis]", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["Q", "1"]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["\[Delta]", 
           SubscriptBox["n", 
            RowBox[{"P", "Q", "P", "U"}]]]}]], 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["Q", "1"]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["U", "1"]}]], "\[CenterEllipsis]", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["Q", "2"]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["\[Delta]", 
           SubscriptBox["n", 
            RowBox[{"P", "Q"}]]]}]]},
       {"\[VerticalEllipsis]", "\[DescendingEllipsis]", "\[VerticalEllipsis]",
         "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
        "\[VerticalEllipsis]"},
       {
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["Q", 
           SubscriptBox["n", 
            RowBox[{"P", "Q"}]]]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["\[Delta]", "1"]}]], "\[CenterEllipsis]", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["Q", 
           SubscriptBox["n", 
            RowBox[{"P", "Q"}]]]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["\[Delta]", 
           SubscriptBox["n", 
            RowBox[{"P", "Q", "P", "U"}]]]}]], 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["Q", 
           SubscriptBox["n", 
            RowBox[{"P", "Q"}]]]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["U", "1"]}]], "\[CenterEllipsis]", 
        FractionBox[
         RowBox[{"\[PartialD]", 
          SubscriptBox["Q", "2"]}], 
         RowBox[{"\[PartialD]", 
          SubscriptBox["\[Delta]", 
           SubscriptBox["n", 
            RowBox[{"P", "Q"}]]]}]]}
      }], ")"}]}], TraditionalForm]],
  FontFamily->"Times New Roman"]
}], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.6642678139486017`*^9, 3.664267833740631*^9}, {
   3.664267912815747*^9, 3.6642679334477777`*^9}, {3.6642690092936063`*^9, 
   3.664269010173608*^9}, {3.664269046512661*^9, 3.6642690471126623`*^9}, {
   3.6642701088136835`*^9, 3.6642701648767653`*^9}, {3.6642702081878276`*^9, 
   3.6642702081878276`*^9}, {3.6642702690229177`*^9, 3.66427031042498*^9}, {
   3.66427179855649*^9, 3.664271799456491*^9}, {3.6642718453815575`*^9, 
   3.6642718501515636`*^9}},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[BoxData[
 RowBox[{"J", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"PQ", "/.", "SSDos"}], ")"}], "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"\[Delta]U", "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "[", "\[Delta]U", "]"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "\[Delta]U", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.6642590988002343`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Prvn\[IAcute] iterace - 0",
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]], "Subsection",
 CellChangeTimes->{{3.61323945547954*^9, 3.6132394662141542`*^9}, {
  3.6132395729292574`*^9, 3.613239575352396*^9}, {3.6132397890546193`*^9, 
  3.6132397919267836`*^9}, {3.6132444707903996`*^9, 3.613244478053815*^9}, {
  3.6133099855775814`*^9, 3.613309991193903*^9}, {3.613361159142213*^9, 
  3.6133611606554155`*^9}, {3.619347779305542*^9, 3.619347779680564*^9}, {
  3.6642564296866603`*^9, 3.6642564359366693`*^9}, {3.66425915033631*^9, 
  3.6642591564263186`*^9}},
 Background->RGBColor[
  0.5764705882352941, 0.8588235294117647, 0.611764705882353]],

Cell[TextData[{
 StyleBox["Pro jednodimension\[AAcute]ln\[IAcute] p\[RHacek]\[IAcute]pad:",
  FontFamily->"Times New Roman"],
 "\n\n",
 Cell[BoxData[
  FormBox[
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{"\[CapitalDelta]", 
         SuperscriptBox["c", "0"]}], "=", 
        RowBox[{"c", "\[Minus]", 
         RowBox[{"f", "(", 
          SuperscriptBox["x", "0"], ")"}]}]}]},
      {
       RowBox[{
        RowBox[{"\[CapitalDelta]", 
         SuperscriptBox["x", "0"]}], "=", 
        FractionBox[
         RowBox[{"\[CapitalDelta]", 
          SuperscriptBox["c", "0"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"d", "f"}], 
            RowBox[{"d", "x"}]], ")"}], "k"]]}]},
      {
       RowBox[{
        SuperscriptBox["x", "k"], "=", 
        RowBox[{
         SuperscriptBox["x", "0"], "+", 
         RowBox[{"\[CapitalDelta]", 
          SuperscriptBox["x", "0"]}]}]}]},
      {
       RowBox[{
        RowBox[{"\[CapitalDelta]", 
         SuperscriptBox["c", "k"]}], "=", 
        RowBox[{"c", "\[Minus]", 
         RowBox[{"f", "(", 
          SuperscriptBox["x", "k"], ")"}]}]}]},
      {"\[VerticalEllipsis]"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]],
  FontFamily->"Times New Roman"],
 "\n",
 StyleBox["Pro \[RHacek]e\[SHacek]en\[IAcute] ust\[AAcute]len\[EAcute]ho \
stavu:",
  FontFamily->"Times New Roman"],
 "\n\n",
 Cell[BoxData[
  FormBox[GridBox[{
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"[", GridBox[{
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True]}]},
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True]}]}
          }], "]"}], "0"], "=", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"[", GridBox[{
            {
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True]},
            {
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True]}
           }], "]"}], "W"], "\[Minus]", 
        RowBox[{"[", GridBox[{
           {
            RowBox[{
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True], "(", 
             SuperscriptBox[
              OverscriptBox[
               RowBox[{"\[Delta]", "U"}], 
               StyleBox["\.af",
                SpanMinSize->0.,
                SpanMaxSize->DirectedInfinity[1]],
               DiacriticalPositioning->True], "0"], ")"}]},
           {
            RowBox[{
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True], "(", 
             SuperscriptBox[
              OverscriptBox[
               RowBox[{"\[Delta]", "U"}], 
               StyleBox["\.af",
                SpanMinSize->0.,
                SpanMaxSize->DirectedInfinity[1]],
               DiacriticalPositioning->True], "0"], ")"}]}
          }], "]"}]}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"[", GridBox[{
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["\[Delta]", "\.af",
              DiacriticalPositioning->True]}]},
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["U", "\.af",
              DiacriticalPositioning->True]}]}
          }], "]"}], "0"], "=", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"[", 
          RowBox[{"J", "(", 
           SuperscriptBox[
            OverscriptBox[
             RowBox[{"\[Delta]", "U"}], 
             StyleBox["\.af",
              SpanMinSize->0.,
              SpanMaxSize->DirectedInfinity[1]],
             DiacriticalPositioning->True], "0"], ")"}], "]"}], 
         RowBox[{"\[Minus]", "1"}]], ".", 
        SuperscriptBox[
         RowBox[{"[", GridBox[{
            {
             RowBox[{"\[CapitalDelta]", 
              OverscriptBox["P", "\.af",
               DiacriticalPositioning->True]}]},
            {
             RowBox[{"\[CapitalDelta]", 
              OverscriptBox["Q", "\.af",
               DiacriticalPositioning->True]}]}
           }], "]"}], "0"]}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"[", GridBox[{
           {
            OverscriptBox["\[Delta]", "\.af",
             DiacriticalPositioning->True]},
           {
            OverscriptBox["U", "\.af",
             DiacriticalPositioning->True]}
          }], "]"}], "k"], "=", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"[", GridBox[{
            {
             OverscriptBox["\[Delta]", "\.af",
              DiacriticalPositioning->True]},
            {
             OverscriptBox["U", "\.af",
              DiacriticalPositioning->True]}
           }], "]"}], "0"], "+", 
        SuperscriptBox[
         RowBox[{"[", GridBox[{
            {
             RowBox[{"\[CapitalDelta]", 
              OverscriptBox["\[Delta]", "\.af",
               DiacriticalPositioning->True]}]},
            {
             RowBox[{"\[CapitalDelta]", 
              OverscriptBox["U", "\.af",
               DiacriticalPositioning->True]}]}
           }], "]"}], "0"]}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"[", GridBox[{
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True]}]},
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True]}]}
          }], "]"}], "k"], "=", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"[", GridBox[{
            {
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True]},
            {
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True]}
           }], "]"}], "W"], "\[Minus]", 
        RowBox[{"[", GridBox[{
           {
            RowBox[{
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True], "(", 
             SuperscriptBox[
              OverscriptBox[
               RowBox[{"\[Delta]", "U"}], 
               StyleBox["\.af",
                SpanMinSize->0.,
                SpanMaxSize->DirectedInfinity[1]],
               DiacriticalPositioning->True], "k"], ")"}]},
           {
            RowBox[{
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True], "(", 
             SuperscriptBox[
              OverscriptBox[
               RowBox[{"\[Delta]", "U"}], 
               StyleBox["\.af",
                SpanMinSize->0.,
                SpanMaxSize->DirectedInfinity[1]],
               DiacriticalPositioning->True], "k"], ")"}]}
          }], "]"}]}]}]},
     {"\[VerticalEllipsis]"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}], TraditionalForm]],
  FontFamily->"Times New Roman"]
}], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.664267889979714*^9, 3.664267893439719*^9}, {
   3.664268969615547*^9, 3.664268970875549*^9}, {3.664269012433611*^9, 
   3.664269012903611*^9}, {3.6642702634809093`*^9, 3.6642702634809093`*^9}},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[TextData[{
 StyleBox["Jakobiova matice ",
  FontFamily->"Times New Roman"],
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"J", "(", 
     SuperscriptBox[
      OverscriptBox[
       RowBox[{"\[Delta]", "U"}], 
       StyleBox["\.af",
        SpanMinSize->0.,
        SpanMaxSize->DirectedInfinity[1]],
       DiacriticalPositioning->True], "0"], ")"}], "]"}], TraditionalForm]],
  FontFamily->"Times New Roman"],
 " ",
 StyleBox["pro 0-t\[YAcute] krok:",
  FontFamily->"Times New Roman"]
}], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.6642678139486017`*^9, 3.664267833740631*^9}, {
   3.664267912815747*^9, 3.6642679334477777`*^9}, {3.6642690092936063`*^9, 
   3.664269010173608*^9}, {3.664269046512661*^9, 3.6642690471126623`*^9}},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"J0", "=", 
   RowBox[{
    RowBox[{"J", "/.", "\[Delta]UPevnaDos"}], "/.", "\[Delta]U0Dos"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"J0", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.6641910256274495`*^9, 3.6641910271874523`*^9}, {
   3.6641912108415036`*^9, 3.6641912408085475`*^9}, {3.6641912751075983`*^9, 
   3.664191280277605*^9}, {3.6641913131126537`*^9, 3.6641913171916604`*^9}, {
   3.6642058665284033`*^9, 3.6642058676828055`*^9}, {3.664206224849145*^9, 
   3.664206243179205*^9}, {3.6642062736193037`*^9, 3.6642062829793296`*^9}, {
   3.6642063849662237`*^9, 3.6642063880722294`*^9}, {3.66420842116816*^9, 
   3.664208421636161*^9}, 3.664208731589713*^9, 3.6642140831822042`*^9, {
   3.664258242895649*^9, 3.664258283335712*^9}, 3.6642584064338937`*^9, {
   3.6642588065918074`*^9, 3.664258810765814*^9}, {3.6642590359061427`*^9, 
   3.6642590373361444`*^9}, {3.6642590952702293`*^9, 
   3.6642591150712585`*^9}, {3.66426779878158*^9, 3.664267799911581*^9}, 
   3.6642678393776393`*^9, {3.6642679409247885`*^9, 3.6642679586448145`*^9}, {
   3.664298353428748*^9, 3.6642983602501383`*^9}}],

Cell[TextData[{
 StyleBox["Defekt ",
  FontFamily->"Times New Roman"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"[", GridBox[{
       {
        RowBox[{"\[CapitalDelta]", 
         OverscriptBox["P", "\.af",
          DiacriticalPositioning->True]}]},
       {
        RowBox[{"\[CapitalDelta]", 
         OverscriptBox["Q", "\.af",
          DiacriticalPositioning->True]}]}
      }], "]"}], "0"], TraditionalForm]],
  FontFamily->"Times New Roman"],
 " ",
 StyleBox["pro 0-t\[YAcute] krok:",
  FontFamily->"Times New Roman"]
}], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.6642678139486017`*^9, 3.664267833740631*^9}, {
   3.664267912815747*^9, 3.6642679334477777`*^9}, {3.6642679828468494`*^9, 
   3.664268010262889*^9}, {3.664269051216668*^9, 3.6642690519056697`*^9}},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[BoxData[
 RowBox[{"\[CapitalDelta]PQ0", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"PQ", "/.", "PQWDos"}], ")"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"PQ", "/.", "SSDos"}], "/.", "\[Delta]UPevnaDos"}], "/.", 
     "\[Delta]U0Dos"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.6642120800374656`*^9, 3.6642121043925095`*^9}, {
   3.6642122331471395`*^9, 3.6642122627035923`*^9}, 3.6642124364190955`*^9, {
   3.6642125236490517`*^9, 3.6642125288594613`*^9}, {3.6642125716371374`*^9, 
   3.664212574850743*^9}, {3.6642141658175645`*^9, 3.6642141689755692`*^9}, {
   3.6642583114047537`*^9, 3.6642583202047663`*^9}, 3.664258353473815*^9, {
   3.664258860661887*^9, 3.664258863731892*^9}, 3.6642592011273837`*^9, 
   3.664267639997346*^9}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"[", GridBox[{
        {
         RowBox[{"\[CapitalDelta]", 
          OverscriptBox["\[Delta]", "\.af",
           DiacriticalPositioning->True]}]},
        {
         RowBox[{"\[CapitalDelta]", 
          OverscriptBox["U", "\.af",
           DiacriticalPositioning->True]}]}
       }], "]"}], "0"], "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"[", 
       RowBox[{
        SuperscriptBox["J", "0"], "(", 
        SuperscriptBox[
         OverscriptBox[
          RowBox[{"\[Delta]", "U"}], 
          StyleBox["\.af",
           SpanMinSize->0.,
           SpanMaxSize->DirectedInfinity[1]],
          DiacriticalPositioning->True], "0"], ")"}], "]"}], 
      RowBox[{"\[Minus]", "1"}]], ".", 
     SuperscriptBox[
      RowBox[{"[", GridBox[{
         {
          RowBox[{"\[CapitalDelta]", 
           OverscriptBox["P", "\.af",
            DiacriticalPositioning->True]}]},
         {
          RowBox[{"\[CapitalDelta]", 
           OverscriptBox["Q", "\.af",
            DiacriticalPositioning->True]}]}
        }], "]"}], "0"]}]}], TraditionalForm]],
  FontFamily->"Times New Roman"],
 StyleBox["\n",
  FontFamily->"Times New Roman"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"[", GridBox[{
        {
         OverscriptBox["\[Delta]", "\.af",
          DiacriticalPositioning->True]},
        {
         OverscriptBox["U", "\.af",
          DiacriticalPositioning->True]}
       }], "]"}], "k"], "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"[", GridBox[{
         {
          OverscriptBox["\[Delta]", "\.af",
           DiacriticalPositioning->True]},
         {
          OverscriptBox["U", "\.af",
           DiacriticalPositioning->True]}
        }], "]"}], "0"], "+", 
     SuperscriptBox[
      RowBox[{"[", GridBox[{
         {
          RowBox[{"\[CapitalDelta]", 
           OverscriptBox["\[Delta]", "\.af",
            DiacriticalPositioning->True]}]},
         {
          RowBox[{"\[CapitalDelta]", 
           OverscriptBox["U", "\.af",
            DiacriticalPositioning->True]}]}
        }], "]"}], "0"]}]}], TraditionalForm]],
  FontFamily->"Times New Roman"]
}], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.6642678139486017`*^9, 3.664267833740631*^9}, {
   3.664267912815747*^9, 3.6642679334477777`*^9}, {3.6642679828468494`*^9, 
   3.664268010262889*^9}, {3.664268205536173*^9, 3.664268237469219*^9}, {
   3.664268982103566*^9, 3.664268984133569*^9}},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[BoxData[{
 RowBox[{"\[CapitalDelta]\[Delta]U0", "=", 
  RowBox[{
   RowBox[{"Inverse", "[", "J0", "]"}], ".", 
   "\[CapitalDelta]PQ0"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"\[Delta]U", "/.", "\[Delta]U0Dos"}], ")"}], "+", 
  "\[CapitalDelta]\[Delta]U0"}], "\[IndentingNewLine]", 
 RowBox[{"\[Delta]UkDos", "=", 
  RowBox[{"dos", "[", 
   RowBox[{"\[Delta]U", ",", "%"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.664215591347496*^9, 3.6642156224543514`*^9}, {
   3.664215673326442*^9, 3.664215681504856*^9}, {3.6642157126645126`*^9, 
   3.66421575071238*^9}, {3.6642157879710474`*^9, 3.664215821844108*^9}, {
   3.664255474455231*^9, 3.6642554962672644`*^9}, {3.664258366923835*^9, 
   3.664258370792841*^9}, 3.6642584206939135`*^9, {3.664258465316981*^9, 
   3.664258470306988*^9}, {3.6642588783909135`*^9, 3.6642588882309275`*^9}, {
   3.664258939367002*^9, 3.6642589396970024`*^9}, {3.6642589717680497`*^9, 
   3.6642589799090614`*^9}, {3.664259043093153*^9, 3.6642590447531557`*^9}, 
   3.6642592048073883`*^9, {3.6642680545599537`*^9, 3.6642680616909647`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Dal\[SHacek]\[IAcute] iterace - k",
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]], "Subsection",
 CellChangeTimes->{{3.61323945547954*^9, 3.6132394662141542`*^9}, {
  3.6132395729292574`*^9, 3.613239575352396*^9}, {3.6132397890546193`*^9, 
  3.6132397919267836`*^9}, {3.6132444707903996`*^9, 3.613244478053815*^9}, {
  3.6133099855775814`*^9, 3.613309991193903*^9}, {3.613361159142213*^9, 
  3.6133611606554155`*^9}, {3.619347779305542*^9, 3.619347779680564*^9}, {
  3.6642564296866603`*^9, 3.6642564359366693`*^9}, {3.66425915033631*^9, 
  3.6642591701883383`*^9}},
 Background->RGBColor[
  0.5764705882352941, 0.8588235294117647, 0.611764705882353]],

Cell[TextData[{
 StyleBox["Pro \[RHacek]e\[SHacek]en\[IAcute] ust\[AAcute]len\[EAcute]ho \
stavu:",
  FontFamily->"Times New Roman"],
 "\n\n",
 Cell[BoxData[
  FormBox[GridBox[{
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"[", GridBox[{
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True]}]},
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True]}]}
          }], "]"}], "k"], "=", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"[", GridBox[{
            {
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True]},
            {
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True]}
           }], "]"}], "W"], "\[Minus]", 
        RowBox[{"[", GridBox[{
           {
            RowBox[{
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True], "(", 
             SuperscriptBox[
              OverscriptBox[
               RowBox[{"\[Delta]", "U"}], 
               StyleBox["\.af",
                SpanMinSize->0.,
                SpanMaxSize->DirectedInfinity[1]],
               DiacriticalPositioning->True], "k"], ")"}]},
           {
            RowBox[{
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True], "(", 
             SuperscriptBox[
              OverscriptBox[
               RowBox[{"\[Delta]", "U"}], 
               StyleBox["\.af",
                SpanMinSize->0.,
                SpanMaxSize->DirectedInfinity[1]],
               DiacriticalPositioning->True], "k"], ")"}]}
          }], "]"}]}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"[", GridBox[{
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["\[Delta]", "\.af",
              DiacriticalPositioning->True]}]},
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["U", "\.af",
              DiacriticalPositioning->True]}]}
          }], "]"}], "k"], "=", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"[", 
          RowBox[{"J", "(", 
           SuperscriptBox[
            OverscriptBox[
             RowBox[{"\[Delta]", "U"}], 
             StyleBox["\.af",
              SpanMinSize->0.,
              SpanMaxSize->DirectedInfinity[1]],
             DiacriticalPositioning->True], "k"], ")"}], "]"}], 
         RowBox[{"\[Minus]", "1"}]], ".", 
        SuperscriptBox[
         RowBox[{"[", GridBox[{
            {
             RowBox[{"\[CapitalDelta]", 
              OverscriptBox["P", "\.af",
               DiacriticalPositioning->True]}]},
            {
             RowBox[{"\[CapitalDelta]", 
              OverscriptBox["Q", "\.af",
               DiacriticalPositioning->True]}]}
           }], "]"}], "k"]}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"[", GridBox[{
           {
            OverscriptBox["\[Delta]", "\.af",
             DiacriticalPositioning->True]},
           {
            OverscriptBox["U", "\.af",
             DiacriticalPositioning->True]}
          }], "]"}], 
        RowBox[{"k", "+", "1"}]], "=", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"[", GridBox[{
            {
             OverscriptBox["\[Delta]", "\.af",
              DiacriticalPositioning->True]},
            {
             OverscriptBox["U", "\.af",
              DiacriticalPositioning->True]}
           }], "]"}], "k"], "+", 
        SuperscriptBox[
         RowBox[{"[", GridBox[{
            {
             RowBox[{"\[CapitalDelta]", 
              OverscriptBox["\[Delta]", "\.af",
               DiacriticalPositioning->True]}]},
            {
             RowBox[{"\[CapitalDelta]", 
              OverscriptBox["U", "\.af",
               DiacriticalPositioning->True]}]}
           }], "]"}], "k"]}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"[", GridBox[{
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True]}]},
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True]}]}
          }], "]"}], 
        RowBox[{"k", "+", "1"}]], "=", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"[", GridBox[{
            {
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True]},
            {
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True]}
           }], "]"}], "W"], "\[Minus]", 
        RowBox[{"[", GridBox[{
           {
            RowBox[{
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True], "(", 
             SuperscriptBox[
              OverscriptBox[
               RowBox[{"\[Delta]", "U"}], 
               StyleBox["\.af",
                SpanMinSize->0.,
                SpanMaxSize->DirectedInfinity[1]],
               DiacriticalPositioning->True], 
              RowBox[{"k", "+", "1"}]], ")"}]},
           {
            RowBox[{
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True], "(", 
             SuperscriptBox[
              OverscriptBox[
               RowBox[{"\[Delta]", "U"}], 
               StyleBox["\.af",
                SpanMinSize->0.,
                SpanMaxSize->DirectedInfinity[1]],
               DiacriticalPositioning->True], 
              RowBox[{"k", "+", "1"}]], ")"}]}
          }], "]"}]}]}]},
     {"\[VerticalEllipsis]"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}], TraditionalForm]],
  FontFamily->"Times New Roman"]
}], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.664267889979714*^9, 3.664267893439719*^9}, {
   3.6642687835202703`*^9, 3.664268784340272*^9}, 3.6642689313294916`*^9, {
   3.664269064482688*^9, 3.664269064482688*^9}},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[TextData[{
 StyleBox["Jakobiova matice ",
  FontFamily->"Times New Roman"],
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"J", "(", 
     SuperscriptBox[
      OverscriptBox[
       RowBox[{"\[Delta]", "U"}], 
       StyleBox["\.af",
        SpanMinSize->0.,
        SpanMaxSize->DirectedInfinity[1]],
       DiacriticalPositioning->True], "k"], ")"}], "]"}], TraditionalForm]],
  FontFamily->"Times New Roman"],
 " ",
 StyleBox["pro k-t\[YAcute] krok:",
  FontFamily->"Times New Roman"]
}], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.6642678139486017`*^9, 3.664267833740631*^9}, {
   3.664267912815747*^9, 3.6642679334477777`*^9}, {3.6642690092936063`*^9, 
   3.6642690423526554`*^9}},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[BoxData[
 RowBox[{"Jk", "=", 
  RowBox[{
   RowBox[{"J", "/.", "\[Delta]UPevnaDos"}], "/.", 
   "\[Delta]UkDos"}]}]], "Input",
 CellChangeTimes->{{3.6641910256274495`*^9, 3.6641910271874523`*^9}, {
   3.6641912108415036`*^9, 3.6641912408085475`*^9}, {3.6641912751075983`*^9, 
   3.664191280277605*^9}, {3.6641913131126537`*^9, 3.6641913171916604`*^9}, {
   3.6642058665284033`*^9, 3.6642058676828055`*^9}, {3.664206224849145*^9, 
   3.664206243179205*^9}, {3.6642062736193037`*^9, 3.6642062829793296`*^9}, {
   3.6642063849662237`*^9, 3.6642063880722294`*^9}, {3.66420842116816*^9, 
   3.664208421636161*^9}, 3.664208731589713*^9, 3.6642140831822042`*^9, {
   3.664258242895649*^9, 3.664258283335712*^9}, 3.6642584064338937`*^9, {
   3.6642588065918074`*^9, 3.664258810765814*^9}, {3.6642590359061427`*^9, 
   3.6642590373361444`*^9}, {3.6642590952702293`*^9, 
   3.6642591150712585`*^9}, {3.6642591801583524`*^9, 3.6642591833723574`*^9}}],

Cell[TextData[{
 StyleBox["Defekt ",
  FontFamily->"Times New Roman"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"[", GridBox[{
       {
        RowBox[{"\[CapitalDelta]", 
         OverscriptBox["P", "\.af",
          DiacriticalPositioning->True]}]},
       {
        RowBox[{"\[CapitalDelta]", 
         OverscriptBox["Q", "\.af",
          DiacriticalPositioning->True]}]}
      }], "]"}], "k"], TraditionalForm]],
  FontFamily->"Times New Roman"],
 " ",
 StyleBox["pro k-t\[YAcute] krok:",
  FontFamily->"Times New Roman"]
}], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.6642678139486017`*^9, 3.664267833740631*^9}, {
   3.664267912815747*^9, 3.6642679334477777`*^9}, {3.6642690092936063`*^9, 
   3.6642690423526554`*^9}, {3.664269148892812*^9, 3.6642691561688223`*^9}},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[BoxData[
 RowBox[{"\[CapitalDelta]PQk", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"PQ", "/.", "PQWDos"}], ")"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"PQ", "/.", "SSDos"}], "/.", "\[Delta]UPevnaDos"}], "/.", 
     "\[Delta]UkDos"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.6642120800374656`*^9, 3.6642121043925095`*^9}, {
   3.6642122331471395`*^9, 3.6642122627035923`*^9}, 3.6642124364190955`*^9, {
   3.6642125236490517`*^9, 3.6642125288594613`*^9}, {3.6642125716371374`*^9, 
   3.664212574850743*^9}, {3.6642141658175645`*^9, 3.6642141689755692`*^9}, {
   3.6642583114047537`*^9, 3.6642583202047663`*^9}, 3.664258353473815*^9, {
   3.664258860661887*^9, 3.664258863731892*^9}, {3.6642592089073944`*^9, 
   3.6642592191834097`*^9}, 3.6642676602563744`*^9}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      SuperscriptBox[
       RowBox[{"[", GridBox[{
          {
           RowBox[{"\[CapitalDelta]", 
            OverscriptBox["\[Delta]", "\.af",
             DiacriticalPositioning->True]}]},
          {
           RowBox[{"\[CapitalDelta]", 
            OverscriptBox["U", "\.af",
             DiacriticalPositioning->True]}]}
         }], "]"}], "k"], "=", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"[", 
         RowBox[{"J", "(", 
          SuperscriptBox[
           OverscriptBox[
            RowBox[{"\[Delta]", "U"}], 
            StyleBox["\.af",
             SpanMinSize->0.,
             SpanMaxSize->DirectedInfinity[1]],
            DiacriticalPositioning->True], "k"], ")"}], "]"}], 
        RowBox[{"\[Minus]", "1"}]], ".", 
       SuperscriptBox[
        RowBox[{"[", GridBox[{
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["P", "\.af",
              DiacriticalPositioning->True]}]},
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["Q", "\.af",
              DiacriticalPositioning->True]}]}
          }], "]"}], "k"]}]}]},
    {
     RowBox[{
      SuperscriptBox[
       RowBox[{"[", GridBox[{
          {
           OverscriptBox["\[Delta]", "\.af",
            DiacriticalPositioning->True]},
          {
           OverscriptBox["U", "\.af",
            DiacriticalPositioning->True]}
         }], "]"}], 
       RowBox[{"k", "+", "1"}]], "=", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"[", GridBox[{
           {
            OverscriptBox["\[Delta]", "\.af",
             DiacriticalPositioning->True]},
           {
            OverscriptBox["U", "\.af",
             DiacriticalPositioning->True]}
          }], "]"}], "k"], "+", 
       SuperscriptBox[
        RowBox[{"[", GridBox[{
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["\[Delta]", "\.af",
              DiacriticalPositioning->True]}]},
           {
            RowBox[{"\[CapitalDelta]", 
             OverscriptBox["U", "\.af",
              DiacriticalPositioning->True]}]}
          }], "]"}], "k"]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}], TraditionalForm]],
 FontFamily->"Times New Roman"]], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.6642678139486017`*^9, 3.664267833740631*^9}, {
   3.664267912815747*^9, 3.6642679334477777`*^9}, {3.6642679828468494`*^9, 
   3.664268010262889*^9}, {3.664268205536173*^9, 3.664268237469219*^9}, {
   3.664268982103566*^9, 3.664268984133569*^9}, 3.6642692808050065`*^9},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[BoxData[{
 RowBox[{"\[CapitalDelta]\[Delta]Uk", "=", 
  RowBox[{
   RowBox[{"Inverse", "[", "Jk", "]"}], ".", 
   "\[CapitalDelta]PQk"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"\[Delta]U", "/.", "\[Delta]UkDos"}], ")"}], "+", 
  "\[CapitalDelta]\[Delta]Uk"}], "\[IndentingNewLine]", 
 RowBox[{"\[Delta]UkDos", "=", 
  RowBox[{"dos", "[", 
   RowBox[{"\[Delta]U", ",", "%"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.664215591347496*^9, 3.6642156224543514`*^9}, {
   3.664215673326442*^9, 3.664215681504856*^9}, {3.6642157126645126`*^9, 
   3.66421575071238*^9}, {3.6642157879710474`*^9, 3.664215821844108*^9}, {
   3.664255474455231*^9, 3.6642554962672644`*^9}, {3.664258366923835*^9, 
   3.664258370792841*^9}, 3.6642584206939135`*^9, {3.664258465316981*^9, 
   3.664258470306988*^9}, {3.6642588783909135`*^9, 3.6642588882309275`*^9}, {
   3.664258939367002*^9, 3.6642589396970024`*^9}, {3.6642589717680497`*^9, 
   3.6642589799090614`*^9}, {3.664259043093153*^9, 3.6642590447531557`*^9}, {
   3.6642592101573963`*^9, 3.664259237446436*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"newton", "[", 
   RowBox[{"{", 
    RowBox[{"k_", ",", "odhad_", ",", "defekt_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "Jk", ",", "\[CapitalDelta]PQk", ",", "\[CapitalDelta]\[Delta]Uk", ",", 
      RowBox[{"\[Delta]UkDos", "=", "odhad"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Jk", "=", 
      RowBox[{
       RowBox[{"J", "/.", "\[Delta]UPevnaDos"}], "/.", "\[Delta]UkDos"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalDelta]PQk", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"PQ", "/.", "PQWDos"}], ")"}], "-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"PQ", "/.", "SSDos"}], "/.", "\[Delta]UPevnaDos"}], "/.", 
         "\[Delta]UkDos"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalDelta]\[Delta]Uk", "=", 
      RowBox[{
       RowBox[{"Inverse", "[", "Jk", "]"}], ".", "\[CapitalDelta]PQk"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"\[Delta]UkDos", "=", 
      RowBox[{"dos", "[", 
       RowBox[{"\[Delta]U", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Delta]U", "/.", "\[Delta]UkDos"}], ")"}], "+", 
         "\[CapitalDelta]\[Delta]Uk"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k", "+", "1"}], ",", "\[Delta]UkDos", ",", 
       "\[CapitalDelta]PQk"}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.664259456629755*^9, 3.664259488268801*^9}, {
   3.6642595251198545`*^9, 3.664259739674165*^9}, {3.6642599172764215`*^9, 
   3.664259940113454*^9}, {3.664259994400533*^9, 3.664260021417573*^9}, {
   3.664260063871635*^9, 3.664260087445668*^9}, {3.664260714029019*^9, 
   3.664260787552125*^9}, {3.664260989302418*^9, 3.664261000592434*^9}, 
   3.6642676670743847`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NestWhileList", "[", 
   RowBox[{"newton", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "\[Delta]U0Dos", ",", "1000"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{"#", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "]"}], ">", 
      SuperscriptBox["10", 
       RowBox[{"-", "8"}]]}], "&"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<k\>\"", ",", "\"\<\[Delta]UkDos\>\"", ",", 
        "\"\<\[CapitalDelta]PQk\>\""}], "}"}]}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vysDos", "=", 
   RowBox[{"%%", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"Length", "@", "%%"}], ",", "2"}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.6642608387502003`*^9, 3.664260842840206*^9}, {
  3.6642608866712694`*^9, 3.664260945246355*^9}, {3.6642772834869814`*^9, 
  3.664277295874404*^9}, {3.6642773473332944`*^9, 3.664277412383611*^9}, {
  3.664298419414522*^9, 3.664298420061559*^9}, {3.6642996494918785`*^9, 
  3.664299651275981*^9}, {3.6642997297154675`*^9, 3.664299814634324*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{
         SubscriptBox["U", "ii"], ",", "TraditionalForm"}], "]"}], "<>", 
       "\"\< = \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            SubscriptBox["U", "ii"], "*", 
            RowBox[{"Uvzad", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "/.", "\[Delta]UPevnaDos"}], "/.",
           "vysDos"}], ",", "TraditionalForm"}], "]"}], "<>", 
       "\"\< p.u.\>\""}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{
         SubscriptBox["\[Delta]", "ii"], ",", "TraditionalForm"}], "]"}], 
       "<>", "\"\< = \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            FractionBox[
             SubscriptBox["\[Delta]", "ii"], "\[Pi]"], "*", "180"}], "/.", 
           "\[Delta]UPevnaDos"}], "/.", "vysDos"}], ",", "TraditionalForm"}], 
        "]"}], "<>", "\"\<\[Degree]\>\""}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", 
      RowBox[{"Length", "@", "Uzad"}]}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.664299845520091*^9, 3.664299878957003*^9}, {
  3.6642999257536798`*^9, 3.664299932553069*^9}, {3.6642999634658365`*^9, 
  3.664300211809041*^9}, {3.664300271823474*^9, 3.6643002913595915`*^9}, {
  3.664300336354165*^9, 3.664300350241959*^9}, {3.6666903062113905`*^9, 
  3.6666903388804398`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Ur\[CHacek]ete", " ", "vstupuj\[IAcute]c\[IAcute]", " ", "a", " ", 
   "vystupuj\[IAcute]c\[IAcute]", " ", "proudy", " ", "a", " ", 
   "v\[YAcute]kony", " ", "v\[SHacek]ech", " ", "v\[EHacek]tv\[IAcute]", " ", 
   "v", " ", "s\[IAcute]ti"}], "*)"}]], "Input",
 CellChangeTimes->{{3.6666907474959707`*^9, 3.666690748515972*^9}, {
   3.6666910570126867`*^9, 3.666691067559702*^9}, {3.666691109887765*^9, 
   3.666691181206873*^9}, {3.6666912225269337`*^9, 3.6666912563929853`*^9}, {
   3.666691330978142*^9, 3.666691340915156*^9}, {3.6666914944540167`*^9, 
   3.666691531189073*^9}, {3.6666917478374443`*^9, 3.6666917632194667`*^9}, {
   3.6666917978105183`*^9, 3.6666918014505234`*^9}, {3.6666918817436676`*^9, 
   3.666691882753669*^9}, {3.666692582190293*^9, 3.666692582360293*^9}, 
   3.6666932138526006`*^9, {3.6666944298738804`*^9, 3.666694430773882*^9}, {
   3.66669466120922*^9, 3.666694684494254*^9}, {3.6666947312153263`*^9, 
   3.666694732500328*^9}, {3.666694777221399*^9, 3.66669489152957*^9}, 
   3.6666951911010103`*^9, {3.6666952336580725`*^9, 3.66669534918524*^9}, {
   3.666695438604392*^9, 3.666695449781409*^9}, {3.6666956022301874`*^9, 
   3.6666957203263664`*^9}, {3.6666957782444525`*^9, 
   3.6666958777075987`*^9}, {3.6672800248697968`*^9, 3.6672800519258385`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Ur\[CHacek]ete", " ", "ztr\[AAcute]ty", " ", "v", " ", "s\[IAcute]ti"}], 
   "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.6666959902507863`*^9, 3.6666960486228714`*^9}, {
   3.6671502342678947`*^9, 3.667150254147032*^9}, {3.667279994595749*^9, 
   3.667280008003771*^9}, 3.667280062864856*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Vypo\[CHacek]\[IAcute]tejte", " ", "\[UAcute]lohu", " ", "pomoc\[IAcute]",
     " ", "funkce", " ", "FindRoot"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.667151023511037*^9, 3.667151062965294*^9}, {
  3.6671512830768833`*^9, 3.6671513772432694`*^9}, {3.6671517450323057`*^9, 
  3.6671517677526054`*^9}, {3.6671541074852057`*^9, 3.6671541153544216`*^9}, {
  3.6671543642239494`*^9, 3.6671543751751685`*^9}, {3.6672799218936343`*^9, 
  3.6672799596146955`*^9}}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"(*", "*)"}], ",", 
  RowBox[{"(*", "*)"}], "]"}]], "Input",
 CellChangeTimes->{{3.6671519745104313`*^9, 3.667151975486487*^9}, {
  3.667279974766719*^9, 3.667279981020728*^9}}]
}, Open  ]]
},
WindowSize->{1495, 992},
WindowMargins->{{-9, Automatic}, {Automatic, -9}},
Magnification:>1.6 Inherited,
Background->GrayLevel[0.85],
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 29, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 398, 8, 77, "Input"],
Cell[959, 30, 144, 2, 47, "Input"],
Cell[CellGroupData[{
Cell[1128, 36, 600, 10, 102, "Subsection"],
Cell[1731, 48, 4068, 108, 728, "Input"],
Cell[5802, 158, 475, 14, 47, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6314, 177, 627, 10, 102, "Subsection"],
Cell[6944, 189, 275, 6, 47, "Input"],
Cell[7222, 197, 128, 2, 47, "Input"],
Cell[7353, 201, 2198, 57, 251, "Input"],
Cell[9554, 260, 608, 17, 210, "Input"],
Cell[10165, 279, 1012, 26, 135, "Input"],
Cell[11180, 307, 3308, 84, 313, "Input"],
Cell[14491, 393, 2159, 53, 193, "Input"],
Cell[16653, 448, 2692, 55, 280, "Input"],
Cell[19348, 505, 718, 16, 47, "Input"],
Cell[20069, 523, 1474, 38, 135, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21580, 566, 658, 11, 102, "Subsection"],
Cell[22241, 579, 307, 7, 77, "Input"],
Cell[22551, 588, 848, 24, 106, "Input"],
Cell[23402, 614, 1129, 23, 77, "Input"],
Cell[24534, 639, 2454, 60, 230, "Input"],
Cell[26991, 701, 501, 11, 222, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27529, 717, 644, 11, 102, "Subsection"],
Cell[28176, 730, 4667, 139, 244, "Text"],
Cell[32846, 871, 685, 13, 77, "Input"],
Cell[33534, 886, 2387, 63, 119, "Text"],
Cell[35924, 951, 1101, 27, 77, "Input"],
Cell[37028, 980, 7110, 202, 408, "Text"],
Cell[44141, 1184, 690, 20, 47, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44868, 1209, 669, 11, 102, "Subsection"],
Cell[45540, 1222, 7632, 230, 667, "Text"],
Cell[53175, 1454, 1000, 25, 80, "Text"],
Cell[54178, 1481, 1151, 19, 77, "Input"],
Cell[55332, 1502, 1041, 27, 107, "Text"],
Cell[56376, 1531, 769, 16, 47, "Input"],
Cell[57148, 1549, 2771, 84, 165, "Text"],
Cell[59922, 1635, 1099, 20, 106, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61058, 1660, 677, 11, 102, "Subsection"],
Cell[61738, 1673, 6304, 186, 415, "Text"],
Cell[68045, 1861, 954, 25, 80, "Text"],
Cell[69002, 1888, 944, 15, 47, "Input"],
Cell[69949, 1905, 1043, 27, 107, "Text"],
Cell[70995, 1934, 797, 16, 47, "Input"],
Cell[71795, 1952, 2944, 83, 172, "Text"],
Cell[74742, 2037, 1073, 20, 106, "Input"],
Cell[75818, 2059, 1902, 47, 222, "Input"],
Cell[77723, 2108, 1272, 34, 113, "Input"],
Cell[78998, 2144, 1629, 43, 249, "Input"],
Cell[80630, 2189, 1333, 20, 47, "Input"],
Cell[81966, 2211, 370, 8, 77, "Input"],
Cell[82339, 2221, 544, 11, 77, "Input"],
Cell[82886, 2234, 228, 5, 47, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
