(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     30856,        760]
NotebookOptionsPosition[     29365,        708]
NotebookOutlinePosition[     29739,        724]
CellTagsIndexPosition[     29696,        721]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["z", 
    RowBox[{"1", ",", "2"}]], "=", " ", 
   RowBox[{"0.02", "+", 
    RowBox[{"I", "*", "0.04"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"S1", "=", 
  RowBox[{
   SubscriptBox["u", "1"], "*", 
   RowBox[{"Conjugate", "[", 
    FractionBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["u", "1"], "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"I", "*", 
          SubscriptBox["\[Delta]", "1"]}]]}], "-", 
       RowBox[{
        SubscriptBox["u", "2"], "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"I", "*", 
          SubscriptBox["\[Delta]", "2"]}]]}]}], ")"}], 
     SubscriptBox["z", 
      RowBox[{"1", ",", "2"}]]], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"S2", "=", 
  RowBox[{
   SubscriptBox["u", "2"], "*", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"I", "*", 
     SubscriptBox["\[Delta]", "2"]}]], "*", 
   RowBox[{"Conjugate", "[", 
    FractionBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["u", "2"], "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"I", "*", 
          SubscriptBox["\[Delta]", "2"]}]]}], "-", 
       RowBox[{
        SubscriptBox["u", "1"], "*", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"I", "*", 
          SubscriptBox["\[Delta]", "1"]}]]}]}], ")"}], 
     SubscriptBox["z", 
      RowBox[{"1", ",", "2"}]]], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.6658955817337637`*^9, 3.6658955982347937`*^9}, {
   3.6658957386141014`*^9, 3.6658958483582673`*^9}, {3.6658959477364173`*^9, 
   3.6658959715544524`*^9}, {3.6658961238296824`*^9, 3.665896126509686*^9}, {
   3.665897944438662*^9, 3.6658979486286683`*^9}, {3.6659065427933674`*^9, 
   3.6659065429733677`*^9}, {3.6659096601953754`*^9, 3.665909692150424*^9}, {
   3.6659149038689146`*^9, 3.665915011340081*^9}, {3.6659151175578365`*^9, 
   3.665915118537838*^9}, 3.6659152324100103`*^9, {3.6659183518706245`*^9, 
   3.6659183529206266`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"10.`", "\[VeryThinSpace]", "+", 
    RowBox[{"20.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
  RowBox[{"Conjugate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["\[Delta]", "1"]}]], " ", 
     SubscriptBox["u", "1"]}], "-", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["\[Delta]", "2"]}]], " ", 
     SubscriptBox["u", "2"]}]}], "]"}], " ", 
  SubscriptBox["u", "1"]}]], "Output",
 CellChangeTimes->{{3.6658958502302704`*^9, 3.665895852190273*^9}, 
   3.665895977255461*^9, 3.6658961270596867`*^9, 3.665896172554756*^9, 
   3.66589794969067*^9, 3.665901796167494*^9, 3.6659065476133738`*^9, 
   3.6659096467053556`*^9, 3.6659096928404245`*^9, 3.6659144074751387`*^9, 
   3.6659148680228586`*^9, {3.665914990881051*^9, 3.665915012300082*^9}, 
   3.6659151189378386`*^9, 3.6659152005259647`*^9, 3.665915233780012*^9, 
   3.665916104427668*^9, 3.6659181826165266`*^9, 3.665918354140628*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"10.`", "\[VeryThinSpace]", "+", 
    RowBox[{"20.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["\[Delta]", "2"]}]], " ", 
  RowBox[{"Conjugate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Delta]", "1"]}]]}], " ", 
     SubscriptBox["u", "1"]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["\[Delta]", "2"]}]], " ", 
     SubscriptBox["u", "2"]}]}], "]"}], " ", 
  SubscriptBox["u", "2"]}]], "Output",
 CellChangeTimes->{{3.6658958502302704`*^9, 3.665895852190273*^9}, 
   3.665895977255461*^9, 3.6658961270596867`*^9, 3.665896172554756*^9, 
   3.66589794969067*^9, 3.665901796167494*^9, 3.6659065476133738`*^9, 
   3.6659096467053556`*^9, 3.6659096928404245`*^9, 3.6659144074751387`*^9, 
   3.6659148680228586`*^9, {3.665914990881051*^9, 3.665915012300082*^9}, 
   3.6659151189378386`*^9, 3.6659152005259647`*^9, 3.665915233780012*^9, 
   3.665916104427668*^9, 3.6659181826165266`*^9, 3.665918354140628*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["PQ uzel",
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]], "Subsection",
 CellChangeTimes->{{3.61323945547954*^9, 3.6132394662141542`*^9}, {
  3.6132395729292574`*^9, 3.613239575352396*^9}, {3.6132397890546193`*^9, 
  3.6132397919267836`*^9}, {3.6132444707903996`*^9, 3.613244478053815*^9}, {
  3.6133099855775814`*^9, 3.613309991193903*^9}, {3.613361159142213*^9, 
  3.6133611606554155`*^9}, {3.619347779305542*^9, 3.619347779680564*^9}, {
  3.6642564296866603`*^9, 3.6642564359366693`*^9}, {3.665918362572644*^9, 
  3.6659183653026485`*^9}},
 Background->RGBColor[
  0.5764705882352941, 0.8588235294117647, 0.611764705882353]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dosPQ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["u", "1"], "\[Rule]", "1.05"}], ",", 
     RowBox[{
      SubscriptBox["\[Delta]", "1"], "\[Rule]", "0"}], ",", 
     RowBox[{
      SubscriptBox["pz", "2"], "\[Rule]", "2.566"}], ",", 
     RowBox[{
      SubscriptBox["qz", "2"], "\[Rule]", "1.102"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"res", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["pz", "2"], "\[Equal]", 
        RowBox[{"ComplexExpand", "[", 
         RowBox[{"Re", "[", "S2", "]"}], "]"}]}], ",", 
       RowBox[{
        SubscriptBox["qz", "2"], "\[Equal]", 
        RowBox[{"ComplexExpand", "[", 
         RowBox[{"Im", "[", "S2", "]"}], "]"}]}]}], "}"}], "/.", "dosPQ"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["u", "2"], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Delta]", "2"], ",", "0"}], "}"}]}], "}"}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.6658953523010426`*^9, 3.66589537145207*^9}, {
   3.6658963187639775`*^9, 3.66589637987107*^9}, {3.6658964146491213`*^9, 
   3.6658964524181795`*^9}, {3.6658968071112766`*^9, 3.665896913285438*^9}, 
   3.665897044623625*^9, {3.6658977896254177`*^9, 3.6658978142134542`*^9}, {
   3.6659061989657674`*^9, 3.6659062118657856`*^9}, {3.6659064211041665`*^9, 
   3.6659064214641666`*^9}, {3.6659064516742096`*^9, 3.665906488719267*^9}, {
   3.665914581597412*^9, 3.665914724347633*^9}, {3.6659148468128204`*^9, 
   3.6659148946138973`*^9}, {3.6659150160100875`*^9, 3.6659150307041097`*^9}, 
   3.6659151276578507`*^9, {3.6659159660124545`*^9, 3.665915980531476*^9}, {
   3.6659160130605316`*^9, 3.6659160336905603`*^9}, {3.665916063774608*^9, 
   3.665916100236662*^9}, {3.6659183448906155`*^9, 3.665918346040617*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["u", "2"], "\[Rule]", "1.1318679867311732`"}], ",", 
   RowBox[{
    SubscriptBox["\[Delta]", "2"], "\[Rule]", "0.06787087428380986`"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.665895852290273*^9, 3.665896380801071*^9, {3.6658964256491385`*^9, 
   3.6658964527881804`*^9}, 3.665896883100391*^9, 3.6658969144884443`*^9, 
   3.6658970451636257`*^9, {3.6658977938784237`*^9, 3.6658978444625044`*^9}, 
   3.6659017962274942`*^9, 3.6659064892892675`*^9, 3.66590964971536*^9, 
   3.6659096948804274`*^9, 3.6659144076051393`*^9, {3.6659148705228615`*^9, 
   3.665914895193898*^9}, {3.6659150218400955`*^9, 3.6659150310041103`*^9}, {
   3.665915121407842*^9, 3.6659151290478525`*^9}, {3.6659151975559607`*^9, 
   3.6659152026559677`*^9}, 3.665915235830015*^9, 3.6659161008866625`*^9, {
   3.6659181827465343`*^9, 3.6659181952922516`*^9}, 3.665918358620634*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["u", "2"], "*", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"I", "*", 
     SubscriptBox["\[Delta]", "2"]}]]}], "/.", "res"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S1", "/.", "dosPQ"}], "/.", "res"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S2", "/.", "dosPQ"}], "/.", "res"}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalDelta]S", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"S1", "+", "S2"}], "/.", "dosPQ"}], "/.", 
   "res"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]S", "==", 
    RowBox[{
     SubscriptBox["z", 
      RowBox[{"1", ",", "2"}]], "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["u", "2"], "*", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"I", "*", 
             SubscriptBox["\[Delta]", "2"]}]]}], "-", 
          RowBox[{
           SubscriptBox["u", "1"], "*", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"I", "*", 
             SubscriptBox["\[Delta]", "1"]}]]}]}], ")"}], 
        SubscriptBox["z", 
         RowBox[{"1", ",", "2"}]]], "]"}], "2"]}]}], "/.", "dosPQ"}], "/.", 
  "res"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"S2", "-", "\[CapitalDelta]S"}], "\[Equal]", 
    RowBox[{"-", "S1"}]}], "/.", "dosPQ"}], "/.", 
  "res"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.665896917278448*^9, 3.6658969187584505`*^9}, {
  3.665897915285615*^9, 3.6658979342856417`*^9}, {3.6659066640695915`*^9, 
  3.6659067544787235`*^9}, {3.6659067861137733`*^9, 3.665906805312801*^9}, {
  3.6659068445008793`*^9, 3.6659068588709316`*^9}, {3.665907123594426*^9, 
  3.6659071247164907`*^9}, {3.6659097071134467`*^9, 3.665909747990507*^9}, {
  3.665915146469885*^9, 3.665915222159996*^9}, {3.6659152967111034`*^9, 
  3.6659153041211147`*^9}, {3.6659154554933357`*^9, 3.6659154932723904`*^9}, {
  3.665915540722459*^9, 3.665915565738496*^9}, {3.665918172803965*^9, 
  3.665918174967089*^9}}],

Cell[BoxData[
 RowBox[{"1.1292620375113136`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.07676190476190471`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.6658969194504514`*^9, 3.6658970493236327`*^9, {3.665897797580429*^9, 
   3.665897846992508*^9}, {3.6658979231616263`*^9, 3.665897952830674*^9}, 
   3.6659017962374945`*^9, 3.665906495732277*^9, 3.6659066582695827`*^9, {
   3.6659067009406433`*^9, 3.665906718959674*^9}, {3.6659067993327923`*^9, 
   3.665906805582801*^9}, {3.6659068470508833`*^9, 3.665906859780933*^9}, 
   3.6659071256485443`*^9, {3.665909702177439*^9, 3.6659097079634476`*^9}, 
   3.665909749150509*^9, 3.665914407615139*^9, 3.6659151539608965`*^9, {
   3.6659151874029455`*^9, 3.665915237660018*^9}, 3.6659153055811167`*^9, {
   3.665915488362384*^9, 3.6659154938903913`*^9}, {3.6659155424294615`*^9, 
   3.665915566208496*^9}, {3.6659181756961308`*^9, 3.6659181970543523`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2.4442513938687913`"}], "-", 
  RowBox[{"0.8585027877375851`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.6658969194504514`*^9, 3.6658970493236327`*^9, {3.665897797580429*^9, 
   3.665897846992508*^9}, {3.6658979231616263`*^9, 3.665897952830674*^9}, 
   3.6659017962374945`*^9, 3.665906495732277*^9, 3.6659066582695827`*^9, {
   3.6659067009406433`*^9, 3.665906718959674*^9}, {3.6659067993327923`*^9, 
   3.665906805582801*^9}, {3.6659068470508833`*^9, 3.665906859780933*^9}, 
   3.6659071256485443`*^9, {3.665909702177439*^9, 3.6659097079634476`*^9}, 
   3.665909749150509*^9, 3.665914407615139*^9, 3.6659151539608965`*^9, {
   3.6659151874029455`*^9, 3.665915237660018*^9}, 3.6659153055811167`*^9, {
   3.665915488362384*^9, 3.6659154938903913`*^9}, {3.6659155424294615`*^9, 
   3.665915566208496*^9}, {3.6659181756961308`*^9, 3.665918197059353*^9}}],

Cell[BoxData[
 RowBox[{"2.565999999999998`", "\[VeryThinSpace]", "+", 
  RowBox[{"1.1019999999999972`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.6658969194504514`*^9, 3.6658970493236327`*^9, {3.665897797580429*^9, 
   3.665897846992508*^9}, {3.6658979231616263`*^9, 3.665897952830674*^9}, 
   3.6659017962374945`*^9, 3.665906495732277*^9, 3.6659066582695827`*^9, {
   3.6659067009406433`*^9, 3.665906718959674*^9}, {3.6659067993327923`*^9, 
   3.665906805582801*^9}, {3.6659068470508833`*^9, 3.665906859780933*^9}, 
   3.6659071256485443`*^9, {3.665909702177439*^9, 3.6659097079634476`*^9}, 
   3.665909749150509*^9, 3.665914407615139*^9, 3.6659151539608965`*^9, {
   3.6659151874029455`*^9, 3.665915237660018*^9}, 3.6659153055811167`*^9, {
   3.665915488362384*^9, 3.6659154938903913`*^9}, {3.6659155424294615`*^9, 
   3.665915566208496*^9}, {3.6659181756961308`*^9, 3.665918197062353*^9}}],

Cell[BoxData[
 RowBox[{"0.12174860613120675`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.24349721226241205`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.6658969194504514`*^9, 3.6658970493236327`*^9, {3.665897797580429*^9, 
   3.665897846992508*^9}, {3.6658979231616263`*^9, 3.665897952830674*^9}, 
   3.6659017962374945`*^9, 3.665906495732277*^9, 3.6659066582695827`*^9, {
   3.6659067009406433`*^9, 3.665906718959674*^9}, {3.6659067993327923`*^9, 
   3.665906805582801*^9}, {3.6659068470508833`*^9, 3.665906859780933*^9}, 
   3.6659071256485443`*^9, {3.665909702177439*^9, 3.6659097079634476`*^9}, 
   3.665909749150509*^9, 3.665914407615139*^9, 3.6659151539608965`*^9, {
   3.6659151874029455`*^9, 3.665915237660018*^9}, 3.6659153055811167`*^9, {
   3.665915488362384*^9, 3.6659154938903913`*^9}, {3.6659155424294615`*^9, 
   3.665915566208496*^9}, {3.6659181756961308`*^9, 3.665918197064353*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.6658969194504514`*^9, 3.6658970493236327`*^9, {3.665897797580429*^9, 
   3.665897846992508*^9}, {3.6658979231616263`*^9, 3.665897952830674*^9}, 
   3.6659017962374945`*^9, 3.665906495732277*^9, 3.6659066582695827`*^9, {
   3.6659067009406433`*^9, 3.665906718959674*^9}, {3.6659067993327923`*^9, 
   3.665906805582801*^9}, {3.6659068470508833`*^9, 3.665906859780933*^9}, 
   3.6659071256485443`*^9, {3.665909702177439*^9, 3.6659097079634476`*^9}, 
   3.665909749150509*^9, 3.665914407615139*^9, 3.6659151539608965`*^9, {
   3.6659151874029455`*^9, 3.665915237660018*^9}, 3.6659153055811167`*^9, {
   3.665915488362384*^9, 3.6659154938903913`*^9}, {3.6659155424294615`*^9, 
   3.665915566208496*^9}, {3.6659181756961308`*^9, 3.6659181970673532`*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.6658969194504514`*^9, 3.6658970493236327`*^9, {3.665897797580429*^9, 
   3.665897846992508*^9}, {3.6658979231616263`*^9, 3.665897952830674*^9}, 
   3.6659017962374945`*^9, 3.665906495732277*^9, 3.6659066582695827`*^9, {
   3.6659067009406433`*^9, 3.665906718959674*^9}, {3.6659067993327923`*^9, 
   3.665906805582801*^9}, {3.6659068470508833`*^9, 3.665906859780933*^9}, 
   3.6659071256485443`*^9, {3.665909702177439*^9, 3.6659097079634476`*^9}, 
   3.665909749150509*^9, 3.665914407615139*^9, 3.6659151539608965`*^9, {
   3.6659151874029455`*^9, 3.665915237660018*^9}, 3.6659153055811167`*^9, {
   3.665915488362384*^9, 3.6659154938903913`*^9}, {3.6659155424294615`*^9, 
   3.665915566208496*^9}, {3.6659181756961308`*^9, 3.6659181970703535`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["PU uzel",
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]], "Subsection",
 CellChangeTimes->{{3.61323945547954*^9, 3.6132394662141542`*^9}, {
  3.6132395729292574`*^9, 3.613239575352396*^9}, {3.6132397890546193`*^9, 
  3.6132397919267836`*^9}, {3.6132444707903996`*^9, 3.613244478053815*^9}, {
  3.6133099855775814`*^9, 3.613309991193903*^9}, {3.613361159142213*^9, 
  3.6133611606554155`*^9}, {3.619347779305542*^9, 3.619347779680564*^9}, {
  3.6642564296866603`*^9, 3.6642564359366693`*^9}, {3.665918362572644*^9, 
  3.6659183858436785`*^9}},
 Background->RGBColor[
  0.5764705882352941, 0.8588235294117647, 0.611764705882353]],

Cell[TextData[StyleBox["pro zdrojovou orientaci a spot\[RHacek]ebi\[CHacek]:\n\
+Q - kapacitn\[IAcute] charakter\n-Q - induktivn\[IAcute] charakter\n+S - dod\
\[AAcute]vka\n-S - odb\[EHacek]r",
 FontFamily->"Times New Roman"]], "Text",
 CellChangeTimes->{{3.6642661102686405`*^9, 3.664266119536654*^9}, 
   3.6642664112200794`*^9, {3.664266514663229*^9, 3.664266583821331*^9}, 
   3.6642667101375165`*^9, 3.6642675392081985`*^9, {3.6642677072554436`*^9, 
   3.664267729782476*^9}, {3.6642678139486017`*^9, 3.664267833740631*^9}, {
   3.664267912815747*^9, 3.6642679334477777`*^9}, {3.6642690092936063`*^9, 
   3.664269010173608*^9}, {3.664269046512661*^9, 3.6642690471126623`*^9}, {
   3.6659184078357105`*^9, 3.665918448850774*^9}, {3.6659186204160876`*^9, 
   3.6659186282260985`*^9}, {3.6659188904004946`*^9, 3.665918904974536*^9}, {
   3.6668863172125015`*^9, 3.6668863201006665`*^9}},
 Background->RGBColor[0.94, 0.88, 0.94]],

Cell[BoxData[
 GraphicsBox[{
   {AbsoluteThickness[2.6607250597988092`], JoinForm[{"Miter", 4.3}], 
    StrokeForm[Opacity[1.]], EdgeForm[Opacity[1.]], EdgeForm[None], 
    LineBox[{{0.21825395338659742`, 0.6369047866386597}, {0.2916666467984529, 
     0.636904786638659}}]}, 
   {AbsoluteThickness[2.6607250597988092`], JoinForm[{"Miter", 4.3}], 
    StrokeForm[Opacity[1.]], EdgeForm[Opacity[1.]], EdgeForm[None], 
    LineBox[{{0.7490078854858231, 0.8125000127724211}, {0.8224205788976786, 
     0.8125000127724205}}]}, InsetBox[
    StyleBox[Cell[TextData[{
      Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox["u", "1"], "="}], TraditionalForm]]],
      "1,05"
     }],
      GeneratedCell->False,
      CellAutoOverwrite->False,
      CellBaseline->Baseline,
      TextAlignment->Left],
     FontSize->13,
     Magnification->1.4,
     FontColor->RGBColor[1, 0, 0],
     Background->GrayLevel[1.]], {0.09215166615911255, 0.6245591085724195}, {
    Left, Baseline},
    Alignment->{Left, Top}], InsetBox[
    StyleBox[Cell[TextData[{
      Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox["u", "2"], "="}], TraditionalForm]]],
      "1,07"
     }],
      GeneratedCell->False,
      CellAutoOverwrite->False,
      CellBaseline->Baseline,
      TextAlignment->Left],
     FontSize->13,
     Magnification->1.4,
     FontColor->RGBColor[1, 0, 0],
     Background->GrayLevel[1.]], {0.8317901234567904, 0.8016975308641975}, {
    Left, Baseline},
    Alignment->{Left, Top}], 
   {AbsoluteThickness[2.6607250597988092`], JoinForm[{"Miter", 4.3}], 
    StrokeForm[Opacity[1.]], EdgeForm[Opacity[1.]], EdgeForm[None], 
    LineBox[{{0.2962962962962964, 0.6358024691358026}, {0.7469135802469138, 
     0.8132716049382718}}]}, 
   {AbsoluteThickness[2.6607250597988092`], JoinForm[{"Miter", 4.3}], 
    StrokeForm[Opacity[1.]], EdgeForm[Opacity[1.]], EdgeForm[None], 
    LineBox[{{0.2962962962962964, 0.6358024691358026}, {0.748456790123457, 
     0.9197530864197534}}]}, 
   {AbsoluteThickness[2.6607250597988092`], JoinForm[{"Miter", 4.3}], 
    StrokeForm[Opacity[1.]], EdgeForm[Opacity[1.]], EdgeForm[None], 
    LineBox[{{0.300925925925926, 0.6327160493827162}, {0.7515432098765433, 
     0.7206790123456792}}]}, InsetBox[
    StyleBox[Cell[TextData[Cell[BoxData[
      FormBox[
       RowBox[{"-", 
        SubscriptBox["P", "2"]}], TraditionalForm]]]],
      GeneratedCell->False,
      CellAutoOverwrite->False,
      CellBaseline->Baseline,
      TextAlignment->Left],
     FontSize->13,
     Magnification->1.4,
     FontColor->RGBColor[1, 0, 0],
     Background->GrayLevel[1.]], {0.6234567901234569, 0.7222222222222225}, {
    Left, Baseline},
    Alignment->{Left, Top}], InsetBox[
    StyleBox[Cell[TextData[Cell[BoxData[
      FormBox[
       RowBox[{"+", 
        SubscriptBox["Q", "2"]}], TraditionalForm]]]],
      GeneratedCell->False,
      CellAutoOverwrite->False,
      CellBaseline->Baseline,
      TextAlignment->Left],
     FontSize->13,
     Magnification->1.4,
     FontColor->RGBColor[1, 0, 0],
     Background->GrayLevel[1.]], {0.5833333333333335, 0.859567901234568}, {
    Left, Baseline},
    Alignment->{Left, Top}], 
   {EdgeForm[{GrayLevel[0.], Opacity[1.], AbsoluteThickness[
    2.6607250597988092`], JoinForm[{"Miter", 4.3}]}], FaceForm[Hue[
    0., 0., 0.6247186829625188]], 
    StyleBox[RectangleBox[{0.4783950617283952, 0.4984567901234569}, {0.6219135802469138, 0.4490740740740742}],
     RectangleBoxOptions->{RoundingRadius->0}]}, 
   {AbsoluteThickness[2.6607250597988092`], JoinForm[{"Miter", 4.3}], 
    StrokeForm[Opacity[1.]], EdgeForm[Opacity[1.]], EdgeForm[None], 
    LineBox[{{0.6250000000000001, 0.4783950617283952}, {0.7654320987654323, 
     0.4783950617283952}}]}, 
   {AbsoluteThickness[2.6607250597988092`], JoinForm[{"Miter", 4.3}], 
    StrokeForm[Opacity[1.]], EdgeForm[Opacity[1.]], EdgeForm[None], 
    LineBox[{{0.4799382716049385, 0.470679012345679}, {0.3024691358024693, 
     0.470679012345679}}]}, InsetBox[
    StyleBox[Cell["PQ",
      GeneratedCell->False,
      CellAutoOverwrite->False,
      CellBaseline->Baseline,
      TextAlignment->Left],
     FontSize->13,
     Magnification->1.4,
     FontColor->RGBColor[1, 0, 0],
     Background->GrayLevel[1.]], {0.7530864197530865, 0.5169753086419754}, {
    Left, Baseline},
    Alignment->{Left, Top}], InsetBox[
    StyleBox[Cell["SLACK",
      GeneratedCell->False,
      CellAutoOverwrite->False,
      CellBaseline->Baseline,
      TextAlignment->Left],
     FontSize->13,
     Magnification->1.4,
     FontColor->RGBColor[1, 0, 0],
     Background->GrayLevel[1.]], {0.27314814814814825`, 0.5123456790123456}, {
    Left, Baseline},
    Alignment->{Left, Top}], InsetBox[
    StyleBox[Cell[TextData[Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Delta]", "2"], "=", "?"}], TraditionalForm]]]],
      GeneratedCell->False,
      CellAutoOverwrite->False,
      CellBaseline->Baseline,
      TextAlignment->Left],
     FontSize->13,
     Magnification->1.4,
     FontColor->RGBColor[1, 0, 0],
     Background->GrayLevel[1.]], {0.8163580246913582, 0.470679012345679}, {
    Left, Baseline},
    Alignment->{Left, Top}]},
  ContentSelectable->True,
  ImagePadding->{{0., 0.}, {0., 0.}},
  ImageSize->{480, 360},
  PlotRange->{{0., 1.3333333333333335`}, {0., 1.}},
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{
  3.6659185767519674`*^9, {3.665918704477213*^9, 3.6659187721483154`*^9}, {
   3.6659188101753745`*^9, 3.6659188798494787`*^9}, {3.6659189229475975`*^9, 
   3.665918932990612*^9}, {3.6659189750116763`*^9, 3.6659189759916778`*^9}, {
   3.665919014074733*^9, 3.665919061862805*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dosPU", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["u", "1"], "\[Rule]", "1.05"}], ",", 
     RowBox[{
      SubscriptBox["\[Delta]", "1"], "\[Rule]", "0"}], ",", 
     RowBox[{
      SubscriptBox["pz", "2"], "\[Rule]", 
      RowBox[{"-", "2"}]}], ",", 
     RowBox[{
      SubscriptBox["u", "2"], "\[Rule]", "1.07"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resPU", "=", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["pz", "2"], "==", 
        RowBox[{"ComplexExpand", "[", 
         RowBox[{"Re", "[", "S2", "]"}], "]"}]}], "}"}], "/.", "dosPU"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Delta]", "2"], ",", "0"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["u", "2"], "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["u", "2"], "/.", "dosPU"}], ")"}]}], "}"}], ",", "%"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6659159046583614`*^9, 3.665915933733403*^9}, {
   3.665916437983259*^9, 3.665916478757318*^9}, {3.6659165529745617`*^9, 
   3.6659166360396814`*^9}, {3.6659169684970827`*^9, 
   3.6659169691531205`*^9}, {3.665918011844759*^9, 3.665918013095831*^9}, 
   3.6659181003708224`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["u", "2"], "\[Rule]", "1.07`"}], ",", 
   RowBox[{
    SubscriptBox["\[Delta]", "2"], "\[Rule]", 
    RowBox[{"-", "0.10126586675387499`"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.665914407655139*^9, {3.6659164566682854`*^9, 3.665916479367319*^9}, {
   3.6659165950206227`*^9, 3.6659166365596824`*^9}, 3.6659169698261585`*^9, 
   3.665918013651862*^9, 3.665918100869851*^9, {3.665918182819538*^9, 
   3.665918192738106*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["u", "2"], "*", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"I", "*", 
      SubscriptBox["\[Delta]", "2"]}]]}], "/.", "dosPU"}], "/.", 
  "resPU"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S1", "/.", "dosPU"}], "/.", "resPU"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S2", "/.", "dosPU"}], "/.", "resPU"}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalDelta]S", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"S1", "+", "S2"}], "/.", "dosPU"}], "/.", 
   "resPU"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]S", "==", 
    RowBox[{
     SubscriptBox["z", 
      RowBox[{"1", ",", "2"}]], "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["u", "2"], "*", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"I", "*", 
             SubscriptBox["\[Delta]", "2"]}]]}], "-", 
          RowBox[{
           SubscriptBox["u", "1"], "*", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"I", "*", 
             SubscriptBox["\[Delta]", "1"]}]]}]}], ")"}], 
        SubscriptBox["z", 
         RowBox[{"1", ",", "2"}]]], "]"}], "2"]}]}], "/.", "dosPU"}], "/.", 
  "resPU"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"S2", "-", "\[CapitalDelta]S"}], "\[Equal]", 
    RowBox[{"-", "S1"}]}], "/.", "dosPU"}], "/.", 
  "resPU"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.665896917278448*^9, 3.6658969187584505`*^9}, {
  3.665897915285615*^9, 3.6658979342856417`*^9}, {3.6659066640695915`*^9, 
  3.6659067544787235`*^9}, {3.6659067861137733`*^9, 3.665906805312801*^9}, {
  3.6659068445008793`*^9, 3.6659068588709316`*^9}, {3.665907123594426*^9, 
  3.6659071247164907`*^9}, {3.6659097071134467`*^9, 3.665909747990507*^9}, {
  3.665915146469885*^9, 3.665915222159996*^9}, {3.6659152967111034`*^9, 
  3.6659153041211147`*^9}, {3.6659154554933357`*^9, 3.6659154932723904`*^9}, {
  3.665915540722459*^9, 3.665915565738496*^9}, {3.665916484467326*^9, 
  3.665916520432378*^9}, {3.66591665542871*^9, 3.665916666042725*^9}, {
  3.665918165388541*^9, 3.6659181676376696`*^9}, {3.6659184308317485`*^9, 
  3.665918431211749*^9}}],

Cell[BoxData[
 RowBox[{"1.0645183817633697`", "\[VeryThinSpace]", "-", 
  RowBox[{"0.10816938054688661`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.6659165008623505`*^9, 3.665916520822378*^9}, 
   3.6659166665227256`*^9, 3.6659169725753164`*^9, 3.6659180169290495`*^9, 
   3.6659181038010187`*^9, 3.6659181828305387`*^9}],

Cell[BoxData[
 RowBox[{"2.119113982969238`", "\[VeryThinSpace]", "-", 
  RowBox[{"1.4406645127730713`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.6659165008623505`*^9, 3.665916520822378*^9}, 
   3.6659166665227256`*^9, 3.6659169725753164`*^9, 3.6659180169290495`*^9, 
   3.6659181038010187`*^9, 3.6659181828345394`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.9999999999999967`"}], "+", 
  RowBox[{"1.6788924787115536`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.6659165008623505`*^9, 3.665916520822378*^9}, 
   3.6659166665227256`*^9, 3.6659169725753164`*^9, 3.6659180169290495`*^9, 
   3.6659181038010187`*^9, 3.6659181828365393`*^9}],

Cell[BoxData[
 RowBox[{"0.11911398296924136`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.23822796593848228`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.6659165008623505`*^9, 3.665916520822378*^9}, 
   3.6659166665227256`*^9, 3.6659169725753164`*^9, 3.6659180169290495`*^9, 
   3.6659181038010187`*^9, 3.6659181828395395`*^9}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.6659165008623505`*^9, 3.665916520822378*^9}, 
   3.6659166665227256`*^9, 3.6659169725753164`*^9, 3.6659180169290495`*^9, 
   3.6659181038010187`*^9, 3.66591818284754*^9}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.6659165008623505`*^9, 3.665916520822378*^9}, 
   3.6659166665227256`*^9, 3.6659169725753164`*^9, 3.6659180169290495`*^9, 
   3.6659181038010187`*^9, 3.6659181828495398`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1920, 1038},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Magnification:>1.6 Inherited,
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 29, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 2037, 55, 199, "Input"],
Cell[2619, 79, 1087, 24, 54, "Output"],
Cell[3709, 105, 1226, 28, 54, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4972, 138, 652, 11, 102, "Subsection"],
Cell[CellGroupData[{
Cell[5649, 153, 1952, 48, 77, "Input"],
Cell[7604, 203, 928, 17, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8569, 225, 2102, 54, 274, "Input"],
Cell[10674, 281, 915, 13, 47, "Output"],
Cell[11592, 296, 910, 14, 47, "Output"],
Cell[12505, 312, 911, 13, 47, "Output"],
Cell[13419, 327, 914, 13, 47, "Output"],
Cell[14336, 342, 804, 11, 47, "Output"],
Cell[15143, 355, 804, 11, 47, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15996, 372, 652, 11, 102, "Subsection"],
Cell[16651, 385, 930, 13, 192, "Text"],
Cell[17584, 400, 5690, 142, 600, "Input"],
Cell[CellGroupData[{
Cell[23299, 546, 1384, 42, 106, "Input"],
Cell[24686, 590, 500, 12, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25223, 607, 2297, 58, 274, "Input"],
Cell[27523, 667, 338, 5, 47, "Output"],
Cell[27864, 674, 336, 5, 47, "Output"],
Cell[28203, 681, 335, 6, 47, "Output"],
Cell[28541, 689, 339, 5, 47, "Output"],
Cell[28883, 696, 224, 3, 47, "Output"],
Cell[29110, 701, 227, 3, 47, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
