(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      6474,        199]
NotebookOptionsPosition[      5821,        175]
NotebookOutlinePosition[      6198,        191]
CellTagsIndexPosition[      6155,        188]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.63490209607183*^9, 3.6349021093165874`*^9}, 
   3.634981012721327*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"MVA", "=", 
   SuperscriptBox["10", "6"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kW", "=", 
   RowBox[{"kV", "=", "1000"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.634901813729681*^9, 3.6349018218791475`*^9}, {
  3.634980998547516*^9, 3.6349810048838787`*^9}, {3.634983674758181*^9, 
  3.6349836767732964`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"T2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"S1", "\[Rule]", 
      RowBox[{"225", "MVA"}]}], ",", 
     RowBox[{"S2", "\[Rule]", 
      RowBox[{"225", "MVA"}]}], ",", 
     RowBox[{"S3", "\[Rule]", 
      RowBox[{"450", "MVA"}]}], ",", 
     RowBox[{"Sn", "\[Rule]", "S3"}], ",", 
     RowBox[{"Pk12", "\[Rule]", 
      RowBox[{"225", "kW"}]}], ",", 
     RowBox[{"Pk13", "\[Rule]", 
      RowBox[{"450", "kW"}]}], ",", 
     RowBox[{"Pk23", "\[Rule]", 
      RowBox[{"450", "kW"}]}], ",", 
     RowBox[{"uk12", "\[Rule]", "0.24"}], ",", 
     RowBox[{"uk23", "\[Rule]", "0.12"}], ",", 
     RowBox[{"uk13", "\[Rule]", "0.12"}], ",", 
     RowBox[{"U1", "\[Rule]", 
      RowBox[{"15", "kV"}]}], ",", 
     RowBox[{"U2", "\[Rule]", 
      RowBox[{"15", "kV"}]}], ",", 
     RowBox[{"U3", "\[Rule]", 
      RowBox[{"420", "kV"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T6", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"S1", "\[Rule]", 
      RowBox[{"350", "MVA"}]}], ",", 
     RowBox[{"S2", "\[Rule]", 
      RowBox[{"350", "MVA"}]}], ",", 
     RowBox[{"S3", "\[Rule]", 
      RowBox[{"100", "MVA"}]}], ",", 
     RowBox[{"Sn", "\[Rule]", "S1"}], ",", 
     RowBox[{"Pk12", "\[Rule]", 
      RowBox[{"590", "kW"}]}], ",", 
     RowBox[{"Pk13", "\[Rule]", 
      RowBox[{"0", "kW"}]}], ",", 
     RowBox[{"Pk23", "\[Rule]", 
      RowBox[{"0", "kW"}]}], ",", 
     RowBox[{"uk12", "\[Rule]", "0.14"}], ",", 
     RowBox[{"uk13", "\[Rule]", "0.20"}], ",", 
     RowBox[{"uk23", "\[Rule]", "0.35"}], ",", 
     RowBox[{"U1", "\[Rule]", 
      RowBox[{"400", "kV"}]}], ",", 
     RowBox[{"U2", "\[Rule]", 
      RowBox[{"121", "kV"}]}], ",", 
     RowBox[{"U3", "\[Rule]", 
      RowBox[{"10.5", "kV"}]}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6349018029650655`*^9, 3.634901867001728*^9}, {
   3.63490190515291*^9, 3.634902016919303*^9}, {3.634902121214268*^9, 
   3.6349023384916954`*^9}, 3.63490254609157*^9, {3.634902676309018*^9, 
   3.6349026777471*^9}, {3.6349028728542595`*^9, 3.634902881755769*^9}, {
   3.6349791615741186`*^9, 3.6349792190914197`*^9}, {3.634980842170805*^9, 
   3.634980844323609*^9}, {3.634980880281672*^9, 3.6349808827152767`*^9}, {
   3.6349809268604155`*^9, 3.634980968947823*^9}, {3.634981106385684*^9, 
   3.634981119089411*^9}, {3.6349817718687477`*^9, 3.634981827614936*^9}, {
   3.6349819549412184`*^9, 3.634981990374245*^9}, {3.634982035439823*^9, 
   3.6349820970293455`*^9}, {3.6349826931612396`*^9, 
   3.6349827453452244`*^9}, {3.6349829871770563`*^9, 3.63498299388144*^9}, {
   3.6349835538802676`*^9, 3.634983571183257*^9}, {3.634983663958564*^9, 
   3.634983696262411*^9}, {3.6349840579348955`*^9, 3.634984107408725*^9}, {
   3.634984493390401*^9, 3.634984498670703*^9}, {3.635071392274216*^9, 
   3.635071411449313*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Trafo", " ", "T2"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", "**", "**"}], "*", "D"}], "********)"}], 
  "\[IndentingNewLine]", "resD"}]], "Input",
 CellChangeTimes->{{3.6668824395997143`*^9, 3.6668824670472846`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"zk12", ",", "zk23", ",", "zk13"}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Un", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"U3n", "\[Rule]", 
      RowBox[{"400", "kV"}]}], ",", 
     RowBox[{"U10n", "\[Rule]", 
      RowBox[{"15", "kV"}]}], ",", 
     RowBox[{"U9n", "\[Rule]", 
      RowBox[{"15", "kV"}]}]}], "}"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"TD", "=", 
  RowBox[{"{", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"T12", " ", "9"}], "-", "10"}], "*)"}], 
   RowBox[{",", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"T23", " ", "10"}], "-", "3"}], "*)"}], ","}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"T31", " ", "3"}], "-", "9"}], "*)"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.6668825042564125`*^9, 3.666882507742612*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"**", "**"}], "**"}], "*", "Y"}], "********)"}]], "Input",
 CellChangeTimes->{3.6668824432229223`*^9}],

Cell[BoxData["resY"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z1", ",", "z2", ",", "z3"}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"TY", "=", 
  RowBox[{"{", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"T10", " ", "9"}], "-", "15"}], "*)"}], 
   RowBox[{",", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"T20", " ", "10"}], "-", "15"}], "*)"}], ","}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"T30", " ", "3"}], "-", "15"}], "*)"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.666882540415481*^9, 3.66688254494274*^9}}]
},
WindowSize->{1668, 1038},
WindowMargins->{{-1676, Automatic}, {Automatic, -8}},
Magnification:>1.6 Inherited,
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 29, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 194, 4, 47, "Input"],
Cell[755, 26, 364, 9, 79, "Input"],
Cell[1122, 37, 2853, 67, 135, "Input"],
Cell[3978, 106, 309, 8, 106, "Input"],
Cell[4290, 116, 91, 2, 47, "Input"],
Cell[4384, 120, 303, 10, 47, "Input"],
Cell[4690, 132, 417, 13, 47, "Input"],
Cell[5110, 147, 167, 5, 47, "Input"],
Cell[5280, 154, 30, 0, 47, "Input"],
Cell[5313, 156, 85, 2, 47, "Input"],
Cell[5401, 160, 416, 13, 47, "Input"]
}
]
*)

(* End of internal cache information *)
